/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.block;

import com.google.common.base.Predicate;
import ipsis.Woot;
import ipsis.woot.block.BlockWoot;
import ipsis.woot.block.ITooltipInfo;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.EnumSpawnerUpgrade;
import ipsis.woot.manager.SpawnerUpgrade;
import ipsis.woot.manager.UpgradeManager;
import ipsis.woot.manager.UpgradeSetup;
import ipsis.woot.manager.loot.FullDropInfo;
import ipsis.woot.oss.client.ModelHelper;
import ipsis.woot.plugins.top.ITOPInfoProvider;
import ipsis.woot.reference.Reference;
import ipsis.woot.reference.Settings;
import ipsis.woot.tileentity.TileEntityMobFactory;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import ipsis.woot.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMobFactory
extends BlockWoot
implements ITooltipInfo,
ITileEntityProvider,
ITOPInfoProvider {
    public static final String BASENAME = "factory";
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockMobFactory() {
        super(Material.field_151576_e, BASENAME);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setRegistryName(Reference.MOD_ID_LOWER, BASENAME);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMobFactory();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing f = placer.func_174811_aO().func_176734_d();
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)f), 2);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        if (worldIn.func_175625_s(pos) instanceof TileEntityMobFactory) {
            TileEntityMobFactory te = (TileEntityMobFactory)worldIn.func_175625_s(pos);
            if (te.isFormed()) {
                List<EnumSpawnerUpgrade> upgradeList;
                ArrayList<String> out = new ArrayList<String>();
                out.add(TextFormatting.BLUE + String.format(te.getFactoryTier().getTranslated("waila.Woot:factory.tier"), new Object[0]));
                out.add(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.mob"), te.getMobDisplayName()));
                int maxMass = Settings.baseMobCount;
                UpgradeSetup upgradeSetup = te.getUpgradeSetup();
                if (upgradeSetup != null && upgradeSetup.hasMassUpgrade()) {
                    maxMass = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getMassUpgrade()).getMass();
                }
                out.add(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.rate"), maxMass, te.getSpawnReq().getSpawnTime()));
                out.add(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.cost"), te.getSpawnReq().getTotalRf(), te.getSpawnReq().getRfPerTick()));
                if (upgradeSetup != null && !(upgradeList = te.getUpgradeSetup().getUpgradeList()).isEmpty()) {
                    for (EnumSpawnerUpgrade upgrade : upgradeList) {
                        SpawnerUpgrade u = UpgradeManager.getSpawnerUpgrade(upgrade);
                        TextFormatting f = u.getUpgradeTier() == 1 ? TextFormatting.GRAY : (u.getUpgradeTier() == 2 ? TextFormatting.GOLD : TextFormatting.AQUA);
                        out.add(f + StringHelper.localize("tooltip.Woot:upgrade." + (Object)((Object)upgrade)));
                    }
                }
                List<ItemStack> requiredItems = Woot.SPAWN_REQ_MANAGER.getItems(te.getMobName(), upgradeSetup);
                FluidStack fluidStack = Woot.SPAWN_REQ_MANAGER.getFluid(te.getMobName(), upgradeSetup);
                if (!requiredItems.isEmpty()) {
                    for (ItemStack itemStack : requiredItems) {
                        out.add(TextFormatting.GOLD + String.format("%d of %s", itemStack.field_77994_a, itemStack.func_82833_r()));
                    }
                } else if (fluidStack != null) {
                    out.add(TextFormatting.GOLD + String.format("%d mb of %s", fluidStack.amount, fluidStack.getLocalizedName()));
                }
                for (String s : out) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(s));
                }
            } else if (!Woot.mobRegistry.isPrismValid(te.getMobName())) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString(String.format(StringHelper.localize("chat.Woot:mob.invalid"), te.getMobDisplayName(), te.getMobName())));
            } else {
                te.manualValidate(playerIn);
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelHelper.registerBlock(ModBlocks.blockFactory, BASENAME);
    }

    @Override
    public void getTooltip(List<String> toolTip, boolean showAdvanced, int meta, boolean detail) {
        toolTip.add(String.format(StringHelper.localize("tooltip.Woot:factory_cost"), "I", Settings.tierIRFtick));
        toolTip.add(String.format(StringHelper.localize("tooltip.Woot:factory_cost"), "II", Settings.tierIIRFtick));
        toolTip.add(String.format(StringHelper.localize("tooltip.Woot:factory_cost"), "III", Settings.tierIIIRFtick));
        toolTip.add(String.format(StringHelper.localize("tooltip.Woot:factory_cost"), "IV", Settings.tierIVRFtick));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityMobFactory factoryTE;
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityMobFactory && (factoryTE = (TileEntityMobFactory)te).isFormed()) {
            PluginTooltipInfo info = new PluginTooltipInfo(factoryTE);
            if (Config.getDefaultConfig().getRFMode() == 1) {
                probeInfo.progress(info.storedRF, info.totalRF, probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat));
            } else {
                probeInfo.text(TextFormatting.RED + "RF: " + ElementProgress.format((long)info.storedRF, (NumberFormat)Config.rfFormat, (String)"RF"));
            }
            probeInfo.horizontal().item(new ItemStack(Items.field_151137_ax), probeInfo.defaultItemStyle().width(14).height(14)).text("State: " + (info.isRunning ? "On" : "Off"));
            if (info.isRunning) {
                int percentage = (int)(100.0f / (float)info.spawnRF * (float)info.consumedRF);
                TextFormatting form = TextFormatting.GREEN;
                if (percentage > 100) {
                    form = TextFormatting.RED;
                }
                percentage = Math.min(percentage, 100);
                probeInfo.horizontal().item(new ItemStack(Items.field_151111_aL), probeInfo.defaultItemStyle().width(14).height(14)).text(form + "Progress: " + percentage + "%");
            }
            probeInfo.text(TextFormatting.BLUE + String.format(info.tier.getTranslated("waila.Woot:factory.tier"), new Object[0]));
            probeInfo.text(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.mob"), info.displayName));
            probeInfo.text(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.rate"), info.maxMass, info.spawnTime));
            probeInfo.text(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.cost"), info.spawnRF, info.spawnTickRF));
            if (mode == ProbeMode.EXTENDED) {
                if (factoryTE.getUpgradeSetup() != null) {
                    for (EnumSpawnerUpgrade e : factoryTE.getUpgradeSetup().getUpgradeList()) {
                        SpawnerUpgrade u = UpgradeManager.getSpawnerUpgrade(e);
                        TextFormatting f = u.getUpgradeTier() == 1 ? TextFormatting.GRAY : (u.getUpgradeTier() == 2 ? TextFormatting.GOLD : TextFormatting.AQUA);
                        probeInfo.text(f + StringHelper.localize("tooltip.Woot:upgrade." + (Object)((Object)e)));
                    }
                    EnumEnchantKey key = factoryTE.getUpgradeSetup().getEnchantKey();
                    List<FullDropInfo> drops = Woot.LOOT_TABLE_MANAGER.getFullDropInfo(factoryTE.getMobName(), key);
                    if (drops != null) {
                        IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-1)).spacing(0));
                        IProbeInfo horizontal = null;
                        int rows = 0;
                        int idx = 0;
                        for (FullDropInfo drop : drops) {
                            if (Woot.LOOT_TABLE_MANAGER.isBlacklisted(drop.getItemStack()) || drop.getItemStack().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150357_h)) continue;
                            if (idx % 10 == 0) {
                                horizontal = vertical.horizontal(probeInfo.defaultLayoutStyle().spacing(0));
                                if (++rows > 4) break;
                            }
                            ItemStack fakeStack = drop.getItemStack().func_77946_l();
                            fakeStack.field_77994_a = (int)Math.ceil(drop.getDropChance());
                            horizontal.item(fakeStack);
                            ++idx;
                        }
                    }
                } else {
                    probeInfo.text(StringHelper.localize("waila.Woot:factory.nullupgrades"));
                }
            } else {
                probeInfo.text(StringHelper.localize("waila.Woot:factory.sneak"));
            }
        }
    }

    public static class PluginTooltipInfo {
        public String displayName;
        public EnumMobFactoryTier tier;
        public int spawnTime;
        public int spawnTickRF;
        public int spawnRF;
        public int storedRF;
        public int totalRF;
        public boolean isRunning;
        public int maxMass;
        public boolean strict;
        public int consumedRF;

        public PluginTooltipInfo(TileEntityMobFactory te) {
            this.displayName = te.getMobDisplayName();
            this.tier = te.getFactoryTier();
            this.spawnTime = te.getSpawnReq().getSpawnTime();
            this.spawnTickRF = te.getSpawnReq().getRfPerTick();
            this.spawnRF = te.getSpawnReq().getTotalRf();
            this.storedRF = te.getEnergyManager().getEnergyStored();
            this.totalRF = te.getEnergyManager().getMaxEnergyStored();
            this.isRunning = te.isRunning();
            this.consumedRF = te.getConsumedRf();
            this.maxMass = Settings.baseMobCount;
            UpgradeSetup upgradeSetup = te.getUpgradeSetup();
            if (upgradeSetup != null && upgradeSetup.hasMassUpgrade()) {
                this.maxMass = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getMassUpgrade()).getMass();
            }
        }

        private PluginTooltipInfo() {
        }

        public void toNBT(NBTTagCompound tag) {
            tag.func_74778_a("displayName", this.displayName);
            tag.func_74774_a("tier", (byte)this.tier.ordinal());
            tag.func_74768_a("spawnTicks", this.spawnTime);
            tag.func_74768_a("spawnRf", this.spawnRF);
            tag.func_74768_a("rfPerTick", this.spawnTickRF);
            tag.func_74757_a("running", this.isRunning);
            tag.func_74768_a("energy", this.storedRF);
            tag.func_74768_a("maxEnergy", this.totalRF);
            tag.func_74768_a("mobCount", this.maxMass);
            tag.func_74768_a("consumedEnergy", this.consumedRF);
        }

        public static PluginTooltipInfo fromNBT(NBTTagCompound tag) {
            PluginTooltipInfo info = new PluginTooltipInfo();
            info.displayName = tag.func_74779_i("displayName");
            info.tier = EnumMobFactoryTier.getTier(tag.func_74771_c("tier"));
            info.spawnTime = tag.func_74762_e("spawnTicks");
            info.spawnRF = tag.func_74762_e("spawnRf");
            info.spawnTickRF = tag.func_74762_e("rfPerTick");
            info.isRunning = tag.func_74767_n("running");
            info.storedRF = tag.func_74762_e("energy");
            info.totalRF = tag.func_74762_e("maxEnergy");
            info.maxMass = tag.func_74762_e("mobCount");
            info.consumedRF = tag.func_74762_e("consumedEnergy");
            return info;
        }
    }
}

