/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.handler.event;

import WayofTime.bloodmagic.annot.Handler;
import WayofTime.bloodmagic.api.soul.DemonWillHolder;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWill;
import WayofTime.bloodmagic.api.soul.IDemonWillWeapon;
import WayofTime.bloodmagic.api.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.demonAura.PosXY;
import WayofTime.bloodmagic.demonAura.WillChunk;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.entity.projectile.EntitySentientArrow;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.registry.ModPotions;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Handler
public class WillHandler {
    private final HashMap<Integer, Integer> serverTicks = new HashMap();

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        if (stack != null && stack.func_77973_b() instanceof IDemonWill) {
            EntityPlayer player = event.getEntityPlayer();
            EnumDemonWillType pickupType = ((IDemonWill)stack.func_77973_b()).getType(stack);
            ItemStack remainder = PlayerDemonWillHandler.addDemonWill(player, stack);
            if (remainder == null || ((IDemonWill)stack.func_77973_b()).getWill(pickupType, stack) < 1.0E-4 || PlayerDemonWillHandler.isDemonWillFull(pickupType, player)) {
                stack.field_77994_a = 0;
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingDeathEvent event) {
        Entity sourceEntity;
        if (event.getSource() instanceof EntityDamageSourceIndirect && (sourceEntity = ((EntityDamageSourceIndirect)event.getSource()).func_76364_f()) instanceof EntitySentientArrow) {
            ((EntitySentientArrow)sourceEntity).reimbursePlayer(event.getEntityLiving(), event.getEntityLiving().func_110138_aP());
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        IDemonWillWeapon demonWillWeapon;
        List<ItemStack> droppedSouls;
        EntityPlayer player;
        ItemStack heldStack;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        if (attackedEntity.func_70644_a(ModPotions.soulSnare) && (attackedEntity instanceof EntityMob || attackedEntity.func_130014_f_().func_175659_aa() == EnumDifficulty.PEACEFUL)) {
            PotionEffect eff = attackedEntity.func_70660_b(ModPotions.soulSnare);
            int lvl = eff.func_76458_c();
            double amountOfSouls = attackedEntity.func_130014_f_().field_73012_v.nextDouble() * (double)(lvl + 1) * (double)(lvl + 1) * 5.0;
            ItemStack soulStack = ((IDemonWill)ModItems.MONSTER_SOUL).createWill(0, amountOfSouls);
            event.getDrops().add(new EntityItem(attackedEntity.func_130014_f_(), attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, soulStack));
        }
        if (entity != null && entity instanceof EntityPlayer && (heldStack = (player = (EntityPlayer)entity).func_184614_ca()) != null && heldStack.func_77973_b() instanceof IDemonWillWeapon && !player.func_130014_f_().field_72995_K && !(droppedSouls = (demonWillWeapon = (IDemonWillWeapon)heldStack.func_77973_b()).getRandomDemonWillDrop(attackedEntity, (EntityLivingBase)player, heldStack, event.getLootingLevel())).isEmpty()) {
            for (ItemStack willStack : droppedSouls) {
                ItemStack remainder = PlayerDemonWillHandler.addDemonWill(player, willStack);
                if (remainder == null) continue;
                EnumDemonWillType pickupType = ((IDemonWill)remainder.func_77973_b()).getType(remainder);
                if (!(((IDemonWill)remainder.func_77973_b()).getWill(pickupType, remainder) >= 1.0E-4)) continue;
                event.getDrops().add(new EntityItem(attackedEntity.func_130014_f_(), attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, remainder));
            }
            player.field_71069_bz.func_75142_b();
        }
    }

    @SubscribeEvent
    public void onServerWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        int dim = event.world.field_73011_w.getDimension();
        if (event.phase == TickEvent.Phase.END) {
            CopyOnWriteArrayList<PosXY> dirtyChunks;
            int ticks;
            if (!this.serverTicks.containsKey(dim)) {
                this.serverTicks.put(dim, 0);
            }
            if ((ticks = this.serverTicks.get(dim).intValue()) % 20 == 0 && (dirtyChunks = WorldDemonWillHandler.dirtyChunks.get(dim)) != null && dirtyChunks.size() > 0) {
                for (PosXY pos : dirtyChunks) {
                    event.world.func_175646_b(new BlockPos(pos.x * 16, 5, pos.y * 16), null);
                }
                dirtyChunks.clear();
            }
            this.serverTicks.put(dim, ticks + 1);
        }
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        ChunkPos loc = event.getChunk().func_76632_l();
        NBTTagCompound nbt = new NBTTagCompound();
        event.getData().func_74782_a("BloodMagic", (NBTBase)nbt);
        WillChunk ac = WorldDemonWillHandler.getWillChunk(dim, loc.field_77276_a, loc.field_77275_b);
        if (ac != null) {
            nbt.func_74777_a("base", ac.getBase());
            ac.getCurrentWill().writeToNBT(nbt, "current");
            if (!event.getChunk().func_177410_o()) {
                WorldDemonWillHandler.removeWillChunk(dim, loc.field_77276_a, loc.field_77275_b);
            }
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        if (event.getData().func_74775_l("BloodMagic").func_74764_b("base")) {
            NBTTagCompound nbt = event.getData().func_74775_l("BloodMagic");
            short base = nbt.func_74765_d("base");
            DemonWillHolder current = new DemonWillHolder();
            current.readFromNBT(nbt, "current");
            WorldDemonWillHandler.addWillChunk(dim, event.getChunk(), base, current);
        } else {
            WorldDemonWillHandler.generateWill(event.getChunk());
        }
    }
}

