/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.upgrade;

import WayofTime.bloodmagic.api.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import org.apache.commons.codec.binary.StringUtils;

public class LivingArmourUpgradeSpeed
extends LivingArmourUpgrade {
    public static final int[] costs = new int[]{3, 7, 13, 26, 42, 60, 90, 130, 180, 250};
    public static final double[] speedModifier = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.7, 0.9, 1.1, 1.3, 1.5};
    public static final int[] sprintSpeedTime = new int[]{0, 0, 0, 0, 0, 20, 60, 60, 100, 200};
    public static final int[] sprintSpeedLevel = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 2};
    public static final int[] healthModifier = new int[]{0, 0, 0, 0, 0, 0, 0, 4, 10, 20};
    public static final int[] sprintRegenTime = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 25};

    public LivingArmourUpgradeSpeed(int level) {
        super(level);
    }

    public double getSpeedModifier() {
        return speedModifier[this.level];
    }

    @Override
    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
        if (player.func_70051_ag()) {
            if (sprintSpeedTime[this.level] > 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, sprintSpeedTime[this.level], sprintSpeedLevel[this.level], false, false));
            }
            if (sprintRegenTime[this.level] > 0 && !player.func_70644_a(MobEffects.field_76428_l)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, sprintRegenTime[this.level], 0, false, false));
            }
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers() {
        HashMultimap modifierMap = HashMultimap.create();
        if (healthModifier[this.level] > 0) {
            String name = this.getUniqueIdentifier() + "-HealthModifier1";
            modifierMap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.nameUUIDFromBytes(StringUtils.getBytesUtf8((String)name)), "HealthModifier1", (double)healthModifier[this.level], 0));
        }
        return modifierMap;
    }

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.upgrade.movement";
    }

    @Override
    public int getMaxTier() {
        return 10;
    }

    @Override
    public int getCostOfUpgrade() {
        return costs[this.level];
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public String getUnlocalizedName() {
        return tooltipBase + "speed";
    }
}

