/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeDigging;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerDigging
extends StatTracker {
    public int totalBlocksDug = 0;
    public static HashMap<LivingArmour, Integer> changeMap = new HashMap();
    public static int[] blocksRequired = new int[]{128, 512, 1024, 2048, 8192, 16000, 32000, 50000, 80000, 150000};

    public static void incrementCounter(LivingArmour armour) {
        changeMap.put(armour, changeMap.containsKey(armour) ? changeMap.get(armour) + 1 : 1);
    }

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.tracker.digging";
    }

    @Override
    public void resetTracker() {
        this.totalBlocksDug = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalBlocksDug = tag.func_74762_e("BloodMagic.tracker.digging");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("BloodMagic.tracker.digging", this.totalBlocksDug);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        int change;
        if (changeMap.containsKey(livingArmour) && (change = Math.abs(changeMap.get(livingArmour))) > 0) {
            this.totalBlocksDug += Math.abs(changeMap.get(livingArmour));
            changeMap.put(livingArmour, 0);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 10; ++i) {
            if (this.totalBlocksDug < blocksRequired[i]) continue;
            upgradeList.add(new LivingArmourUpgradeDigging(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalBlocksDug, blocksRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("BloodMagic.upgrade.digging");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeDigging && (level = upgrade.getUpgradeLevel()) < blocksRequired.length) {
            this.totalBlocksDug = Math.max(this.totalBlocksDug, blocksRequired[level]);
            this.markDirty();
        }
    }
}

