/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.item.sigil.ItemSigilToggleableBase;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemSigilGreenGrove
extends ItemSigilToggleableBase {
    public ItemSigilGreenGrove() {
        super("greenGrove", 150);
    }

    @Override
    public boolean onSigilUse(ItemStack stack, EntityPlayer player, World world, BlockPos blockPos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (PlayerHelper.isFakePlayer(player)) {
            return false;
        }
        if (this.applyBonemeal(world, blockPos, player)) {
            if (!world.field_72995_K) {
                world.func_175718_b(2005, blockPos, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onSigilUpdate(ItemStack stack, World worldIn, EntityPlayer player, int itemSlot, boolean isSelected) {
        if (PlayerHelper.isFakePlayer(player)) {
            return;
        }
        int range = 3;
        int verticalRange = 2;
        int posX = (int)Math.round(player.field_70165_t - 0.5);
        int posY = (int)player.field_70163_u;
        int posZ = (int)Math.round(player.field_70161_v - 0.5);
        for (int ix = posX - range; ix <= posX + range; ++ix) {
            for (int iz = posZ - range; iz <= posZ + range; ++iz) {
                for (int iy = posY - verticalRange; iy <= posY + verticalRange; ++iy) {
                    BlockPos blockPos = new BlockPos(ix, iy, iz);
                    Block block = worldIn.func_180495_p(blockPos).func_177230_c();
                    if (BloodMagicAPI.getGreenGroveBlacklist().contains(block) || !(block instanceof IPlantable) && !(block instanceof IGrowable) || worldIn.field_73012_v.nextInt(50) != 0) continue;
                    IBlockState preBlockState = worldIn.func_180495_p(blockPos);
                    block.func_180650_b(worldIn, blockPos, worldIn.func_180495_p(blockPos), worldIn.field_73012_v);
                    IBlockState newState = worldIn.func_180495_p(blockPos);
                    if (newState.equals(preBlockState) || worldIn.field_72995_K) continue;
                    worldIn.func_175718_b(2005, blockPos, 0);
                }
            }
        }
    }

    private boolean applyBonemeal(World worldIn, BlockPos target, EntityPlayer player) {
        IGrowable igrowable;
        IBlockState iblockstate = worldIn.func_180495_p(target);
        BonemealEvent event = new BonemealEvent(player, worldIn, target, iblockstate);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (iblockstate.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)iblockstate.func_177230_c()).func_176473_a(worldIn, target, iblockstate, worldIn.field_72995_K)) {
            if (!worldIn.field_72995_K && igrowable.func_180670_a(worldIn, worldIn.field_73012_v, target, iblockstate)) {
                igrowable.func_176474_b(worldIn, worldIn.field_73012_v, target, iblockstate);
            }
            return true;
        }
        return false;
    }
}

