/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.gear;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.altar.IAltarManipulator;
import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.iface.IItemLPContainer;
import WayofTime.bloodmagic.api.util.helper.ItemHelper;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemPackSacrifice
extends ItemArmor
implements IAltarManipulator,
IItemLPContainer,
IVariantProvider {
    public final int CAPACITY = 10000;

    public ItemPackSacrifice() {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, EntityEquipmentSlot.CHEST);
        this.func_77655_b("BloodMagic.pack.sacrifice");
        this.func_77637_a(BloodMagic.tabBloodMagic);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        if (rayTrace == null) {
            return super.func_77659_a(stack, world, player, EnumHand.MAIN_HAND);
        }
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tile = world.func_175625_s(rayTrace.func_178782_a());
            if (!(tile instanceof IBloodAltar)) {
                return super.func_77659_a(stack, world, player, EnumHand.MAIN_HAND);
            }
            ItemHelper.LPContainer.tryAndFillAltar((IBloodAltar)tile, stack, world, rayTrace.func_178782_a());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (this.getStoredLP(stack) > 10000) {
            this.setStoredLP(stack, 10000);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        list.add(TextHelper.localize("tooltip.BloodMagic.pack.sacrifice.desc", new Object[0]));
        list.add(TextHelper.localize("tooltip.BloodMagic.pack.stored", this.getStoredLP(stack)));
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)0, (Object)"type=normal"));
        return ret;
    }

    @Override
    public int getCapacity() {
        return this.CAPACITY;
    }

    @Override
    public int getStoredLP(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT(stack).func_77978_p().func_74762_e("storedLP") : 0;
    }

    @Override
    public void setStoredLP(ItemStack stack, int lp) {
        if (stack != null) {
            NBTHelper.checkNBT(stack).func_77978_p().func_74768_a("storedLP", lp);
        }
    }
}

