/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.block;

import WayofTime.bloodmagic.block.BlockBloodTank;
import WayofTime.bloodmagic.tile.TileBloodTank;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockBloodTank
extends ItemBlock
implements IFluidContainerItem {
    public ItemBlockBloodTank(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
        if (fluidStack != null) {
            return super.func_77653_i(stack) + " " + TextHelper.localizeEffect("tooltip.BloodMagic.tier", stack.func_77952_i() + 1) + " (" + fluidStack.getLocalizedName() + ")";
        }
        return super.func_77653_i(stack) + " " + TextHelper.localizeEffect("tooltip.BloodMagic.tier", stack.func_77952_i() + 1);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer entityPlayer, List<String> tooltip, boolean advanced) {
        NBTTagCompound tag;
        FluidStack fluidStack;
        tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.tier", stack.func_77952_i() + 1));
        tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.fluid.capacity", this.getCapacity(stack)));
        if (stack.func_77942_o() && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)(tag = stack.func_77978_p()))) != null) {
            tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.fluid.type", fluidStack.getLocalizedName()));
            tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.fluid.amount", fluidStack.amount, this.getCapacity(stack)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, List<ItemStack> list) {
        for (int i = 0; i < TileBloodTank.CAPACITIES.length; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public FluidStack getFluid(ItemStack stack) {
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
    }

    public int getCapacity(ItemStack container) {
        return container != null && Block.func_149634_a((Item)container.func_77973_b()) instanceof BlockBloodTank ? TileBloodTank.CAPACITIES[container.func_77960_j()] * 1000 : 0;
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (resource == null || stack.field_77994_a != 1) {
            return 0;
        }
        int fillAmount = 0;
        int capacity = this.getCapacity(stack);
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagCompound fluidTag = null;
        FluidStack fluid = null;
        if (tag == null || !tag.func_74764_b("tank") || (fluidTag = tag.func_74775_l("tank")) == null || (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag)) == null) {
            fillAmount = Math.min(capacity, resource.amount);
        }
        if (fluid == null) {
            if (doFill) {
                fluid = resource.copy();
                fluid.amount = 0;
            }
        } else {
            if (!fluid.isFluidEqual(resource)) {
                return 0;
            }
            fillAmount = Math.min(capacity - fluid.amount, resource.amount);
        }
        fillAmount = Math.max(fillAmount, 0);
        if (doFill) {
            if (tag == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            tag = stack.func_77978_p();
            fluid.amount += fillAmount;
            tag.func_74782_a("tank", (NBTBase)fluid.writeToNBT(fluidTag == null ? new NBTTagCompound() : fluidTag));
        }
        return fillAmount;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        FluidStack fluid;
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagCompound fluidTag = null;
        if (tag == null || !tag.func_74764_b("tank") || (fluidTag = tag.func_74775_l("tank")) == null || (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag)) == null) {
            if (fluidTag != null) {
                tag.func_82580_o("tank");
            }
            return null;
        }
        int drainAmount = Math.min(maxDrain, fluid.amount);
        if (doDrain) {
            tag.func_82580_o("tank");
            fluid.amount -= drainAmount;
            if (fluid.amount > 0) {
                this.fill(stack, fluid, true);
            }
        }
        fluid.amount = drainAmount;
        return fluid;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, this.getCapacity(stack));
    }
}

