/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compress;

import WayofTime.bloodmagic.BloodMagic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class StorageBlockCraftingRecipeAssimilator {
    public static final List<Class> ignore = new ArrayList<Class>();

    public List<IRecipe> getPackingRecipes() {
        LinkedList<PackingRecipe> packingRecipes = new LinkedList<PackingRecipe>();
        ArrayList<IRecipe> unpackingRecipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : this.getCraftingRecipes()) {
            ItemStack output;
            if (ignore.contains(recipe.getClass()) || (output = recipe.func_77571_b()) == null || output.func_77973_b() == null) continue;
            if (output.field_77994_a == 1) {
                PackingRecipe packingRecipe = this.getPackingRecipe(recipe);
                if (packingRecipe == null) continue;
                packingRecipes.add(packingRecipe);
                continue;
            }
            if (output.field_77994_a != 4 && output.field_77994_a != 9 || recipe.func_77570_a() != 1) continue;
            unpackingRecipes.add(recipe);
        }
        Container container = this.makeDummyContainer();
        InventoryCrafting inventoryUnpack = new InventoryCrafting(container, 2, 2);
        InventoryCrafting inventory2x2 = new InventoryCrafting(container, 2, 2);
        InventoryCrafting inventory3x3 = new InventoryCrafting(container, 3, 3);
        World world = null;
        ArrayList<IRecipe> ret = new ArrayList<IRecipe>();
        for (IRecipe recipeUnpack : unpackingRecipes) {
            if (ignore.contains(recipeUnpack.getClass())) continue;
            ItemStack unpacked = recipeUnpack.func_77571_b();
            InventoryCrafting inventory = null;
            Iterator it = packingRecipes.iterator();
            while (it.hasNext()) {
                PackingRecipe recipePack = (PackingRecipe)it.next();
                boolean matched = false;
                if (recipePack.possibleInputs != null) {
                    if (recipePack.inputCount != unpacked.field_77994_a) continue;
                    for (ItemStack stack : recipePack.possibleInputs) {
                        if (!this.areInputsIdentical(unpacked, stack)) continue;
                        matched = true;
                        break;
                    }
                } else {
                    if (unpacked.field_77994_a == 9 && recipePack.recipe.func_77570_a() < 9) continue;
                    if (inventory == null) {
                        inventory = unpacked.field_77994_a == 4 ? inventory2x2 : inventory3x3;
                        for (int i = 0; i < unpacked.field_77994_a; ++i) {
                            inventory.func_70299_a(i, unpacked.func_77946_l());
                        }
                    }
                    matched = recipePack.recipe.func_77569_a(inventory, world);
                }
                if (!matched) continue;
                ItemStack packOutput = recipePack.recipe.func_77571_b();
                inventoryUnpack.func_70299_a(0, packOutput.func_77946_l());
                if (!recipeUnpack.func_77569_a(inventoryUnpack, world)) continue;
                ret.add(recipePack.recipe);
                it.remove();
            }
        }
        return ret;
    }

    private List<IRecipe> getCraftingRecipes() {
        return CraftingManager.func_77594_a().func_77592_b();
    }

    private Container makeDummyContainer() {
        return new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return true;
            }
        };
    }

    private PackingRecipe getPackingRecipe(IRecipe recipe) {
        ArrayList inputs;
        if (recipe.func_77570_a() < 4) {
            return null;
        }
        if (recipe instanceof ShapedRecipes) {
            inputs = Arrays.asList(((ShapedRecipes)recipe).field_77574_d);
        } else if (recipe instanceof ShapelessRecipes) {
            inputs = ((ShapelessRecipes)recipe).field_77579_b;
        } else if (recipe instanceof ShapedOreRecipe) {
            inputs = Arrays.asList(((ShapedOreRecipe)recipe).getInput());
        } else if (recipe instanceof ShapelessOreRecipe) {
            inputs = ((ShapelessOreRecipe)recipe).getInput();
        } else {
            return new PackingRecipe(recipe, null, -1);
        }
        int count = 0;
        for (Object o : inputs) {
            if (o == null) continue;
            ++count;
        }
        if (count != 4 && count != 9) {
            return null;
        }
        List<ItemStack> identicalInputs = this.getIdenticalInputs(inputs);
        if (identicalInputs == null) {
            return null;
        }
        return new PackingRecipe(recipe, identicalInputs, count);
    }

    private List<ItemStack> getIdenticalInputs(List<?> inputs) {
        ArrayList options = null;
        for (Object input : inputs) {
            List offers;
            if (input == null) continue;
            if (input instanceof ItemStack) {
                offers = Collections.singletonList((ItemStack)input);
            } else if (input instanceof List) {
                offers = (List)input;
                if (offers.isEmpty()) {
                    return null;
                }
            } else {
                throw new RuntimeException("invalid input: " + input.getClass());
            }
            if (options == null) {
                options = new ArrayList(offers);
                continue;
            }
            Iterator it = options.iterator();
            while (it.hasNext()) {
                ItemStack stackReq = (ItemStack)it.next();
                boolean found = false;
                for (ItemStack stackCmp : offers) {
                    if (!this.areInputsIdentical(stackReq, stackCmp)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                it.remove();
                if (!options.isEmpty()) continue;
                return null;
            }
        }
        return options;
    }

    private boolean areInputsIdentical(ItemStack a, ItemStack b) {
        try {
            int dmgB;
            if (a.func_77973_b() != b.func_77973_b()) {
                return false;
            }
            int dmgA = a.func_77952_i();
            return dmgA == (dmgB = b.func_77952_i()) || dmgA == Short.MAX_VALUE || dmgB == Short.MAX_VALUE;
        }
        catch (NullPointerException e) {
            BloodMagic.instance.getLogger().error("A mod in this instance has registered an item with a null input. Known problem mods are:", new Object[0]);
            return false;
        }
    }

    private static class PackingRecipe {
        final IRecipe recipe;
        final List<ItemStack> possibleInputs;
        final int inputCount;

        PackingRecipe(IRecipe recipe, List<ItemStack> possibleInputs, int inputCount) {
            this.recipe = recipe;
            this.possibleInputs = possibleInputs;
            this.inputCount = inputCount;
        }
    }
}

