/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.tile.routing.TileMasterRoutingNode;
import WayofTime.bloodmagic.tile.routing.TileRoutingNode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockRoutingNode
extends BlockContainer {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.378f, (double)0.378f, (double)0.378f, 0.625, 0.625, 0.625);
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public BlockRoutingNode() {
        super(Material.field_151576_e);
        this.func_149647_a(BloodMagic.tabBloodMagic);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u() {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.shouldConnect(state, worldIn, pos.func_177984_a(), EnumFacing.DOWN))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.shouldConnect(state, worldIn, pos.func_177977_b(), EnumFacing.UP))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.shouldConnect(state, worldIn, pos.func_177978_c(), EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.shouldConnect(state, worldIn, pos.func_177974_f(), EnumFacing.WEST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.shouldConnect(state, worldIn, pos.func_177968_d(), EnumFacing.NORTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.shouldConnect(state, worldIn, pos.func_177976_e(), EnumFacing.EAST)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, NORTH, EAST, WEST, SOUTH});
    }

    public boolean shouldConnect(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing attachedSide) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        return block.func_149688_o(blockState).func_76218_k() && blockState.func_185917_h();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileRoutingNode) {
                ((TileRoutingNode)tile).removeAllConnections();
            } else if (tile instanceof TileMasterRoutingNode) {
                ((TileMasterRoutingNode)tile).removeAllConnections();
            }
        }
        super.func_180663_b(world, pos, blockState);
    }
}

