/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.item.ItemDemonCrystal;
import WayofTime.bloodmagic.tile.TileDemonCrystal;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDemonCrystal
extends BlockContainer {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)6);
    public static final PropertyEnum<EnumDemonWillType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumDemonWillType.class);
    public static final PropertyEnum<EnumFacing> ATTACHED = PropertyEnum.func_177709_a((String)"attached", EnumFacing.class);

    public BlockDemonCrystal() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumDemonWillType.DEFAULT)).func_177226_a(ATTACHED, (Comparable)EnumFacing.UP));
        this.func_149663_c("BloodMagic.demonCrystal.");
        this.func_149647_a(BloodMagic.tabBloodMagic);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos offsetPos = pos.func_177972_a(side.func_176734_d());
        IBlockState offsetState = world.func_180495_p(offsetPos);
        Block offsetBlock = offsetState.func_177230_c();
        return offsetBlock.isSideSolid(offsetState, (IBlockAccess)world, offsetPos, side) && this.func_176196_c(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        TileDemonCrystal tile = (TileDemonCrystal)world.func_175625_s(pos);
        EnumFacing placement = tile.getPlacement();
        BlockPos offsetPos = pos.func_177972_a(placement.func_176734_d());
        IBlockState offsetState = world.func_180495_p(offsetPos);
        Block offsetBlock = offsetState.func_177230_c();
        if (!offsetBlock.isSideSolid(offsetState, (IBlockAccess)world, offsetPos, placement)) {
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) == null) {
            return state;
        }
        TileDemonCrystal tile = (TileDemonCrystal)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(tile.getCrystalCountForRender())).func_177226_a(ATTACHED, (Comparable)tile.getPlacement());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (int i = 0; i < EnumDemonWillType.values().length; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u() {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumDemonWillType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDemonWillType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, AGE, ATTACHED});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileDemonCrystal();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDemonCrystal) {
            EnumDemonWillType type = (EnumDemonWillType)((Object)state.func_177229_b(TYPE));
            int number = ((TileDemonCrystal)tile).getCrystalCount();
            BlockDemonCrystal.func_180635_a((World)world, (BlockPos)pos, (ItemStack)BlockDemonCrystal.getItemStackDropped(type, number));
            world.func_175713_t(pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public static ItemStack getItemStackDropped(EnumDemonWillType type, int crystalNumber) {
        ItemStack stack = null;
        switch (type) {
            case CORROSIVE: {
                stack = ItemDemonCrystal.getStack("crystalCorrosive");
                break;
            }
            case DEFAULT: {
                stack = ItemDemonCrystal.getStack("crystalDefault");
                break;
            }
            case DESTRUCTIVE: {
                stack = ItemDemonCrystal.getStack("crystalDestructive");
                break;
            }
            case STEADFAST: {
                stack = ItemDemonCrystal.getStack("crystalSteadfast");
                break;
            }
            case VENGEFUL: {
                stack = ItemDemonCrystal.getStack("crystalVengeful");
            }
        }
        stack.field_77994_a = crystalNumber;
        return stack;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileDemonCrystal crystal = (TileDemonCrystal)world.func_175625_s(pos);
        if (PlayerDemonWillHandler.getTotalDemonWill(EnumDemonWillType.DEFAULT, player) > 1024.0) {
            crystal.dropSingleCrystal();
            world.func_184138_a(pos, state, state, 3);
        }
        return true;
    }
}

