/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.util.helper;

import WayofTime.bloodmagic.api.registry.RitualRegistry;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class RitualHelper {
    @CapabilityInject(value=IRitualStone.Tile.class)
    static Capability<IRitualStone.Tile> RUNE_CAPABILITY = null;

    public static boolean canCrystalActivate(Ritual ritual, int crystalLevel) {
        return ritual.getCrystalLevel() <= crystalLevel && RitualRegistry.ritualEnabled(ritual);
    }

    public static String getNextRitualKey(String currentKey) {
        int currentIndex = RitualRegistry.getIds().indexOf(currentKey);
        int nextIndex = RitualRegistry.getRituals().listIterator(currentIndex).nextIndex();
        return RitualRegistry.getIds().get(nextIndex);
    }

    public static String getPrevRitualKey(String currentKey) {
        int currentIndex = RitualRegistry.getIds().indexOf(currentKey);
        int previousIndex = RitualRegistry.getIds().listIterator(currentIndex).previousIndex();
        return RitualRegistry.getIds().get(previousIndex);
    }

    public static String getValidRitual(World world, BlockPos pos) {
        for (String key : RitualRegistry.getIds()) {
            for (EnumFacing direction : EnumFacing.field_176754_o) {
                boolean test = RitualHelper.checkValidRitual(world, pos, key, direction);
                if (!test) continue;
                return key;
            }
        }
        return "";
    }

    public static EnumFacing getDirectionOfRitual(World world, BlockPos pos, String key) {
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            boolean test = RitualHelper.checkValidRitual(world, pos, key, direction);
            if (!test) continue;
            return direction;
        }
        return null;
    }

    public static boolean checkValidRitual(World world, BlockPos pos, String ritualId, EnumFacing direction) {
        Ritual ritual = RitualRegistry.getRitualForId(ritualId);
        if (ritual == null) {
            return false;
        }
        ArrayList<RitualComponent> components = ritual.getComponents();
        if (components == null) {
            return false;
        }
        for (RitualComponent component : components) {
            BlockPos newPos = pos.func_177971_a((Vec3i)component.getOffset(direction));
            if (RitualHelper.isRuneType(world, newPos, component.getRuneType())) continue;
            return false;
        }
        return true;
    }

    public static boolean isRuneType(World world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (block instanceof IRitualStone) {
            return ((IRitualStone)block).isRuneType(world, pos, type);
        }
        if (tile instanceof IRitualStone.Tile) {
            return ((IRitualStone.Tile)tile).isRuneType(type);
        }
        if (tile != null && tile.hasCapability(RUNE_CAPABILITY, null)) {
            return ((IRitualStone.Tile)tile.getCapability(RUNE_CAPABILITY, null)).isRuneType(type);
        }
        return false;
    }

    public static boolean isRune(World world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (block instanceof IRitualStone) {
            return true;
        }
        if (tile instanceof IRitualStone.Tile) {
            return true;
        }
        return tile != null && tile.hasCapability(RUNE_CAPABILITY, null);
    }

    public static void setRuneType(World world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (block instanceof IRitualStone) {
            ((IRitualStone)block).setRuneType(world, pos, type);
        } else if (tile instanceof IRitualStone.Tile) {
            ((IRitualStone.Tile)tile).setRuneType(type);
        } else if (tile != null && tile.hasCapability(RUNE_CAPABILITY, null)) {
            ((IRitualStone.Tile)tile.getCapability(RUNE_CAPABILITY, null)).setRuneType(type);
            world.func_180496_d(pos, block);
        }
    }
}

