/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.registry;

import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.ritual.imperfect.ImperfectRitual;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImperfectRitualRegistry {
    public static final Map<ImperfectRitual, Boolean> enabledRituals = new HashMap<ImperfectRitual, Boolean>();
    private static final BiMap<String, ImperfectRitual> registry = HashBiMap.create();

    public static void registerRitual(ImperfectRitual imperfectRitual, String id, boolean enabled) {
        if (imperfectRitual != null) {
            if (registry.containsKey((Object)id)) {
                BloodMagicAPI.getLogger().error("Duplicate imperfect ritual id: %s", id);
            } else {
                registry.put((Object)id, (Object)imperfectRitual);
                enabledRituals.put(imperfectRitual, enabled);
            }
        }
    }

    public static void registerRitual(ImperfectRitual imperfectRitual, String id) {
        ImperfectRitualRegistry.registerRitual(imperfectRitual, id, true);
    }

    public static void registerRitual(ImperfectRitual imperfectRitual, boolean enabled) {
        ImperfectRitualRegistry.registerRitual(imperfectRitual, imperfectRitual.getName(), enabled);
    }

    public static void registerRitual(ImperfectRitual imperfectRitual) {
        ImperfectRitualRegistry.registerRitual(imperfectRitual, imperfectRitual.getName());
    }

    public static ImperfectRitual getRitualForBlock(BlockStack blockStack) {
        for (ImperfectRitual imperfectRitual : ImperfectRitualRegistry.getRegistry().values()) {
            if (!imperfectRitual.getRequiredBlock().equals(blockStack)) continue;
            return imperfectRitual;
        }
        return null;
    }

    public static ImperfectRitual getRitualForId(String id) {
        return (ImperfectRitual)registry.get((Object)id);
    }

    public static String getIdForRitual(ImperfectRitual imperfectRitual) {
        return (String)registry.inverse().get((Object)imperfectRitual);
    }

    public static boolean isMapEmpty() {
        return registry.isEmpty();
    }

    public static int getMapSize() {
        return registry.size();
    }

    public static boolean ritualEnabled(ImperfectRitual imperfectRitual) {
        try {
            return enabledRituals.get(imperfectRitual);
        }
        catch (NullPointerException e) {
            BloodMagicAPI.getLogger().error("Invalid Imperfect Ritual was called", new Object[0]);
            return false;
        }
    }

    public static boolean ritualEnabled(String id) {
        return ImperfectRitualRegistry.ritualEnabled(ImperfectRitualRegistry.getRitualForId(id));
    }

    public static BiMap<String, ImperfectRitual> getRegistry() {
        return HashBiMap.create(registry);
    }

    public static BiMap<ImperfectRitual, Boolean> getEnabledMap() {
        return HashBiMap.create(enabledRituals);
    }

    public static ArrayList<String> getIds() {
        return new ArrayList<String>(registry.keySet());
    }

    public static ArrayList<ImperfectRitual> getRituals() {
        return new ArrayList<ImperfectRitual>(registry.values());
    }
}

