/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.compress;

import WayofTime.bloodmagic.api.compress.CompressionHandler;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CompressionRegistry {
    public static List<CompressionHandler> compressionRegistry = new ArrayList<CompressionHandler>();
    public static Map<ItemStack, Integer> thresholdMap = new HashMap<ItemStack, Integer>();

    public static void registerHandler(CompressionHandler handler) {
        compressionRegistry.add(handler);
    }

    public static void registerItemThreshold(ItemStack stack, int threshold) {
        thresholdMap.put(stack, threshold);
    }

    public static ItemStack compressInventory(ItemStack[] inv, World world) {
        for (CompressionHandler handler : compressionRegistry) {
            ItemStack stack = handler.compressInventory(inv, world);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    public static Pair<ItemStack, Boolean> compressInventory(TileEntity tile, World world) {
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack[] inventory = new ItemStack[itemHandler.getSlots()];
            ItemStack[] copyInventory = new ItemStack[itemHandler.getSlots()];
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                inventory[slot] = itemHandler.extractItem(slot, 64, true);
                copyInventory[slot] = ItemStack.func_77944_b((ItemStack)inventory[slot]);
            }
            for (CompressionHandler handler : compressionRegistry) {
                ItemStack stack = handler.compressInventory(copyInventory, world);
                if (stack == null) continue;
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    if (inventory[slot] == null || ItemStack.func_77989_b((ItemStack)inventory[slot], (ItemStack)copyInventory[slot])) continue;
                    itemHandler.extractItem(slot, inventory[slot].field_77994_a, false);
                    if (copyInventory[slot] == null) continue;
                    itemHandler.insertItem(slot, copyInventory[slot], false);
                }
                return Pair.of((Object)Utils.insertStackIntoTile(stack, itemHandler), (Object)true);
            }
        }
        return Pair.of(null, (Object)false);
    }

    public static int getItemThreshold(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> entry : thresholdMap.entrySet()) {
            if (!CompressionRegistry.areItemStacksEqual(entry.getKey(), stack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static boolean areItemStacksEqual(ItemStack stack, ItemStack compressedStack) {
        return stack.func_77969_a(compressedStack) && (stack.func_77978_p() == null ? compressedStack.func_77978_p() == null : stack.func_77978_p().equals((Object)compressedStack.func_77978_p()));
    }
}

