/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.alchemyCrafting;

import WayofTime.bloodmagic.tile.TileAlchemyArray;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class AlchemyCircleRenderer {
    public float offsetFromFace = -0.9f;
    public final ResourceLocation arrayResource;

    public AlchemyCircleRenderer() {
        this(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/SightSigil.png"));
    }

    public AlchemyCircleRenderer(ResourceLocation arrayResource) {
        this.arrayResource = arrayResource;
    }

    public float getRotation(float craftTime) {
        float offset = 2.0f;
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.5);
            return modifier * 1.0f;
        }
        return 0.0f;
    }

    public float getSecondaryRotation(float craftTime) {
        float offset = 50.0f;
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.7);
            return modifier * 0.5f;
        }
        return 0.0f;
    }

    public float getSizeModifier(float craftTime) {
        if (craftTime >= 150.0f && craftTime <= 250.0f) {
            return (200.0f - craftTime) / 50.0f;
        }
        return 1.0f;
    }

    public float getVerticalOffset(float craftTime) {
        if (craftTime >= 5.0f) {
            if (craftTime <= 40.0f) {
                return (float)(-0.4 * Math.pow((craftTime - 5.0f) / 35.0f, 3.0));
            }
            return -0.4f;
        }
        return 0.0f;
    }

    public void renderAt(TileEntity tile, double x, double y, double z, float craftTime) {
        if (!(tile instanceof TileAlchemyArray)) {
            return;
        }
        TileAlchemyArray tileArray = (TileAlchemyArray)tile;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer wr = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        float rot = this.getRotation(craftTime);
        float secondaryRot = this.getSecondaryRotation(craftTime);
        float size = 1.0f * this.getSizeModifier(craftTime);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.arrayResource);
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        EnumFacing sideHit = EnumFacing.UP;
        EnumFacing rotation = tileArray.getRotation();
        GlStateManager.func_179109_b((float)((float)sideHit.func_82601_c() * this.offsetFromFace), (float)((float)sideHit.func_96559_d() * this.offsetFromFace), (float)((float)sideHit.func_82599_e() * this.offsetFromFace));
        switch (sideHit) {
            case DOWN: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)this.getVerticalOffset(craftTime));
        GlStateManager.func_179114_b((float)(rotation.func_185119_l() + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)secondaryRot, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(secondaryRot * 0.45812f), (float)0.0f, (float)0.0f, (float)1.0f);
        double var31 = 0.0;
        double var33 = 1.0;
        double var35 = 0.0;
        double var37 = 1.0;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)(size / 2.0f), (double)(size / 2.0f), 0.0).func_187315_a(var33, var37).func_181675_d();
        wr.func_181662_b((double)(size / 2.0f), (double)(-size / 2.0f), 0.0).func_187315_a(var33, var35).func_181675_d();
        wr.func_181662_b((double)(-size / 2.0f), (double)(-size / 2.0f), 0.0).func_187315_a(var31, var35).func_181675_d();
        wr.func_181662_b((double)(-size / 2.0f), (double)(size / 2.0f), 0.0).func_187315_a(var31, var37).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

