/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.utils;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.xalcon.torchmaster.common.utils.NbtUtils;

public class BlockUtils {
    public static IBlockState getBlockStateFromItemStack(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        return block.func_176203_a(itemStack.func_77960_j());
    }

    public static int[] createSpiralMap(int radius) {
        int x = 0;
        int y = 0;
        int layer = 1;
        int arm = 0;
        int[] array = new int[(radius + radius + 1) * (radius + radius + 1) * 2];
        block6: for (int i = 0; i < array.length; i += 2) {
            array[i] = x++;
            array[i + 1] = y++;
            switch (arm) {
                case 0: {
                    if (x != layer) continue block6;
                    ++arm;
                    continue block6;
                }
                case 1: {
                    if (y != layer) continue block6;
                    ++arm;
                    continue block6;
                }
                case 2: {
                    if (-(--x) != layer) continue block6;
                    ++arm;
                    continue block6;
                }
                case 3: {
                    if (-(--y) != layer) continue block6;
                    ++layer;
                    arm = 0;
                }
            }
        }
        return array;
    }

    public static void addTagToSpawner(String tag, TileEntityMobSpawner spawner) {
        NBTTagCompound nbt = new NBTTagCompound();
        spawner.func_145881_a().func_189530_b(nbt);
        BlockUtils.patchSpawnNbt(tag, nbt);
        spawner.func_145881_a().func_98270_a(nbt);
    }

    public static void addTagToXU2Spawner(String tag, TileEntity spawner) {
        NBTTagCompound compound = new NBTTagCompound();
        spawner.func_189515_b(compound);
        NBTTagCompound spawnerNbt = compound.func_74775_l("spawner");
        if (spawnerNbt.func_82582_d()) {
            return;
        }
        BlockUtils.patchSpawnNbt(tag, spawnerNbt);
        spawner.func_145839_a(compound);
    }

    private static void patchSpawnNbt(String tag, NBTTagCompound nbt) {
        NBTTagCompound spawnDataNbt = nbt.func_74775_l("SpawnData");
        BlockUtils.addTagToEntity(tag, spawnDataNbt);
        NBTTagList spawnPotentialNbt = nbt.func_150295_c("SpawnPotentials", 10);
        for (int i = 0; i < spawnPotentialNbt.func_74745_c(); ++i) {
            NBTTagCompound weightEntry = spawnPotentialNbt.func_150305_b(i);
            NBTTagCompound entityTag = weightEntry.func_74775_l("Entity");
            BlockUtils.addTagToEntity(tag, entityTag);
        }
    }

    private static NBTTagCompound addTagToEntity(String tag, NBTTagCompound entity) {
        NBTTagList entityTagsList = entity.func_150295_c("Tags", 8);
        if (!NbtUtils.isStringInTagList(tag, entityTagsList)) {
            entityTagsList.func_74742_a((NBTBase)new NBTTagString(tag));
            if (!entity.func_74764_b("Tags")) {
                entity.func_74782_a("Tags", (NBTBase)entityTagsList);
            }
        }
        return entity;
    }
}

