/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.xalcon.torchmaster.TorchMasterMod;
import net.xalcon.torchmaster.client.IItemRenderRegister;
import net.xalcon.torchmaster.common.blocks.BlockBase;
import net.xalcon.torchmaster.common.items.ItemBlockMegaTorch;
import net.xalcon.torchmaster.common.tiles.IAutoRegisterTileEntity;
import net.xalcon.torchmaster.common.tiles.TileEntityMegaTorch;
import net.xalcon.torchmaster.common.utils.BlockUtils;
import net.xalcon.torchmaster.common.utils.ItemstackUtils;

public class BlockMegaTorch
extends BlockBase
implements ITileEntityProvider,
IAutoRegisterTileEntity {
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.35, 0.0, 0.35, 0.65, 1.0, 0.65);
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");

    public BlockMegaTorch() {
        super(Material.field_151575_d, "mega_torch");
        this.func_149711_c(1.5f);
        this.func_149752_b(1.0f);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.getTorchState(true));
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, this.func_176201_c(this.getTorchState(true))));
        list.add(new ItemStack(itemIn, 1, this.func_176201_c(this.getTorchState(false))));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMegaTorch();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityMegaTorch.class;
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BURNING);
    }

    @Override
    public String getTileEntityRegistryName() {
        return "tile_mega_torch";
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STANDING_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            if (TorchMasterMod.ConfigHandler.isVanillaSpawnerEnabled()) {
                long startTime = System.nanoTime();
                for (TileEntity te : worldIn.field_175730_i) {
                    if (te instanceof TileEntityMobSpawner) {
                        BlockUtils.addTagToSpawner("IsSpawnerMob", (TileEntityMobSpawner)te);
                        continue;
                    }
                    if (!"extrautils2:supermobspawner".equals(te.func_145838_q().getRegistryName().toString())) continue;
                    BlockUtils.addTagToXU2Spawner("IsSpawnerMob", te);
                }
                long diff = System.nanoTime() - startTime;
                TorchMasterMod.Log.info("MegaTorch placed down @ " + pos + " (DIM: " + worldIn.field_73011_w.getDimension() + "); MobSpawner scan took " + diff + "ns");
            }
            if (!stack.func_77942_o()) {
                return;
            }
            TileEntity tile = worldIn.func_175625_s(pos);
            if (!(tile instanceof TileEntityMegaTorch)) {
                return;
            }
            NBTTagCompound compound = stack.func_179543_a("tm_tile", false);
            if (compound != null) {
                ((TileEntityMegaTorch)tile).readSyncNbt(compound);
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".already_lit", new Object[0]));
            return true;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (ItemstackUtils.isEmpty(itemStack)) {
            return true;
        }
        String itemId = itemStack.func_77973_b().getRegistryName().toString();
        if (!TorchMasterMod.ConfigHandler.getMegaTorchLighterItems().contains(itemId)) {
            return false;
        }
        NBTTagCompound nbt = itemStack.func_179543_a("tm_lighter", false);
        int amount = 1;
        float chance = 1.0f;
        if (nbt != null) {
            amount = nbt.func_74762_e("amount");
        }
        if (itemStack.func_77984_f()) {
            int remainingDamage = 1 + itemStack.func_77958_k() - itemStack.func_77952_i();
            chance = (float)remainingDamage / (float)amount;
            itemStack.func_77972_a(amount, (EntityLivingBase)playerIn);
        } else {
            if (amount > itemStack.field_77994_a) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".light_failed_itemcount", new Object[0]));
                return false;
            }
            --itemStack.field_77994_a;
        }
        if (worldIn.field_73012_v.nextFloat() > chance) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".light_failed_itemtoodamaged", new Object[0]));
            return false;
        }
        worldIn.func_175656_a(pos, this.getTorchState(true));
        TileEntity torchTe = worldIn.func_175625_s(pos);
        if (torchTe instanceof TileEntityMegaTorch) {
            ((TileEntityMegaTorch)torchTe).relightTorch(TorchMasterMod.ConfigHandler.getMegaTorchBurnoutValue());
            worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
        } else {
            TorchMasterMod.Log.error("There is an error whith the MegaTorch @ " + pos + ". Please replace the block!");
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.func_177229_b((IProperty)BURNING)).booleanValue()) {
            return;
        }
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 1.1;
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BURNING});
    }

    public IBlockState getTorchState(boolean isLit) {
        return this.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(isLit));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.getTorchState(meta == 0);
    }

    @Override
    public void registerItemModels(ItemBlock itemBlock, IItemRenderRegister register) {
        register.registerItemRenderer((Item)itemBlock, this.func_176201_c(this.getTorchState(true)), this.getRegistryName(), "burning=true");
        register.registerItemRenderer((Item)itemBlock, this.func_176201_c(this.getTorchState(false)), this.getRegistryName(), "burning=false");
    }

    @Override
    public ItemBlock createItemBlock() {
        return (ItemBlock)new ItemBlockMegaTorch(this).setRegistryName(this.getRegistryName());
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? 15 : 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(TorchMasterMod.ConfigHandler.isMegaTorchExtinguishOnHarvest() ? this.getTorchState(false) : state);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return TorchMasterMod.ConfigHandler.isMegaTorchAllowSilkTouch();
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityMegaTorch) {
            ItemStack itemStack;
            if (worldIn.field_72995_K) {
                return;
            }
            if ((!TorchMasterMod.ConfigHandler.isMegaTorchExtinguishOnHarvest() || this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) && !ItemstackUtils.isEmpty(itemStack = this.func_180643_i(state))) {
                player.func_71029_a(StatList.func_188055_a((Block)this));
                player.func_71020_j(0.005f);
                NBTTagCompound compound = itemStack.func_179543_a("tm_tile", true);
                ((TileEntityMegaTorch)te).writeSyncNbt(compound);
                BlockMegaTorch.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
                return;
            }
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }
}

