/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TorchRegistry {
    private static TorchRegistry megaTorchRegistry = new TorchRegistry();
    private static TorchRegistry dreadLampRegistry = new TorchRegistry();
    private List<TorchLocation> torches = new ArrayList<TorchLocation>();
    private int torchRange;
    private int torchRangeSq;

    public static TorchRegistry getMegaTorchRegistry() {
        return megaTorchRegistry;
    }

    public static TorchRegistry getDreadLampRegistry() {
        return dreadLampRegistry;
    }

    public void setTorchRange(int torchRange) {
        this.torchRange = torchRange;
        this.torchRangeSq = torchRange * torchRange;
    }

    public void registerTorch(World world, BlockPos pos) {
        TorchLocation torchLoc = new TorchLocation(world.field_73011_w.getDimension(), pos);
        if (!this.torches.contains(torchLoc)) {
            this.torches.add(torchLoc);
        }
    }

    public void unregisterTorch(World world, BlockPos pos) {
        this.torches.remove(new TorchLocation(world.field_73011_w.getDimension(), pos));
    }

    public boolean isInRangeOfTorch(World world, BlockPos pos) {
        int dim = world.field_73011_w.getDimension();
        for (TorchLocation torch : this.torches) {
            if (torch.DimensionId != dim) continue;
            double dx = (double)torch.Position.func_177958_n() + 0.5 - (double)pos.func_177958_n();
            double dy = Math.abs((double)torch.Position.func_177956_o() + 0.5 - (double)pos.func_177956_o());
            double dz = (double)torch.Position.func_177952_p() + 0.5 - (double)pos.func_177952_p();
            if (!(dx * dx + dz * dz <= (double)this.torchRangeSq) || !(dy <= (double)this.torchRange)) continue;
            return true;
        }
        return false;
    }

    private class TorchLocation {
        public int DimensionId;
        public BlockPos Position;

        public TorchLocation(int dimensionId, BlockPos position) {
            this.DimensionId = dimensionId;
            this.Position = position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TorchLocation that = (TorchLocation)o;
            if (this.DimensionId != that.DimensionId) {
                return false;
            }
            return this.Position != null ? this.Position.equals((Object)that.Position) : that.Position == null;
        }

        public int hashCode() {
            int result = this.DimensionId;
            result = 31 * result + (this.Position != null ? this.Position.hashCode() : 0);
            return result;
        }
    }
}

