/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.xalcon.torchmaster.TorchMasterMod;
import net.xalcon.torchmaster.common.TorchRegistry;

public class ConfigHandler {
    private Configuration config;
    private boolean megaTorchAllowVanillaSpawners;
    private boolean megaTorchExtinguishOnHarvest;
    private boolean megaTorchAllowSilkTouch;
    private int megaTorchBurnoutRate;
    private int megaTorchBurnoutValue;
    private int megaTorchRange;
    private int dreadLampRange;
    private int terrainLighterTorchCount;
    private int terrainLighterSpacing;
    private HashSet<String> terrainLighterTorches;
    private HashSet<String> megaTorchLighterItems;
    public boolean isLycaniteCompatEnabled;
    public boolean isMoCreaturesCompatEnabled;

    public ConfigHandler(File configFile) {
        this.config = new Configuration(configFile);
        this.loadConfigs(false);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("torchmaster")) {
            this.loadConfigs(true);
        }
    }

    private void loadConfigs(boolean reload) {
        try {
            this.megaTorchRange = this.config.getInt("MegaTorchRange", "general", 32, 0, 512, "The radius of the spawn prevention. (Monster)");
            this.megaTorchLighterItems = new HashSet<String>(Arrays.asList(this.config.get("general", "MegaTorchLighterItems", new String[]{"minecraft:flint_and_steel"}, "The lighter item to light an unlit torch, see ADD_WEBSITE_HERE for more info.").getStringList()));
            this.megaTorchBurnoutRate = this.config.getInt("MegaTorchBurnoutRate", "general", 0, 0, Integer.MAX_VALUE, "The speed at which the torch will extinguish. Set to 0 to disable.");
            this.megaTorchBurnoutValue = this.config.getInt("MegaTorchBurnoutValue", "general", Integer.MAX_VALUE, 0, Integer.MAX_VALUE, "The burnout value. This value is removed by the amount of burnout rate per tick");
            this.megaTorchExtinguishOnHarvest = this.config.getBoolean("MegaTorchExtinguishOnHarvest", "general", false, "If set to true, the mega torch will drop as an unlit torch when harvesting it");
            this.megaTorchAllowSilkTouch = this.config.getBoolean("MegaTorchAllowSilkTouch", "general", false, "Allows to get the lit torch when harvested with silk touch. Has no effect if MegaTorchExtinguishOnHarvest is false");
            this.dreadLampRange = this.config.getInt("DreadLampRange", "general", 64, 0, 512, "The radius of the spawn prevention. (Passive Animals)");
            this.megaTorchAllowVanillaSpawners = this.config.getBoolean("MegaTorchAllowVanillaSpawners", "general", true, "Allows vanilla spawners to spawn monsters inside the working radius of a mega torch");
            this.terrainLighterTorchCount = this.config.getInt("TerrainLighterTorchCount", "general", 7, 0, 32, "The amount of torches to place in each direction. The effective range is multiplied by the torch spacing (32 * 5 = 160 blocks, default 7 * 5 = 35 blocks)");
            this.terrainLighterSpacing = this.config.getInt("TerrainLighterSpacing", "general", 5, 1, 16, "The spacing between each torch. Distance of 5 means there will be a torch every 5 blocks with 4 blocks space in between.");
            this.terrainLighterTorches = new HashSet<String>(Arrays.asList(this.config.get("general", "TerrainLighterTorches", new String[]{"minecraft:torch", "tconstruct:stone_torch"}, "This controls which torches are supported by the terrain lighter").getStringList()));
            this.isLycaniteCompatEnabled = this.config.getBoolean("LycanitesMobsBlockAll", "compat", true, "If this setting is enabled, the mega torch will block all natural spawn attempts from Lycanites Mobs in its radius");
            this.isMoCreaturesCompatEnabled = this.config.getBoolean("MoCreaturesBlockAll", "compat", true, "If this setting is enabled, the mega torch will block all natural spawn attempts from MoCreatures in its radius");
        }
        catch (Exception e) {
            TorchMasterMod.Log.error("Error loading config", (Throwable)e);
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
            TorchRegistry.getMegaTorchRegistry().setTorchRange(this.getMegaTorchRange());
            TorchRegistry.getDreadLampRegistry().setTorchRange(this.getDreadLampRange());
        }
    }

    public boolean isVanillaSpawnerEnabled() {
        return this.megaTorchAllowVanillaSpawners;
    }

    public int getMegaTorchRange() {
        return this.megaTorchRange;
    }

    public int getDreadLampRange() {
        return this.dreadLampRange;
    }

    public int getTerrainLighterTorchCount() {
        return this.terrainLighterTorchCount;
    }

    public int getTerrainLighterSpacing() {
        return this.terrainLighterSpacing;
    }

    public HashSet<String> getTerrainLighterTorches() {
        return this.terrainLighterTorches;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public HashSet<String> getMegaTorchLighterItems() {
        return this.megaTorchLighterItems;
    }

    public boolean isMegaTorchExtinguishOnHarvest() {
        return this.megaTorchExtinguishOnHarvest;
    }

    public boolean isMegaTorchAllowSilkTouch() {
        return this.megaTorchAllowSilkTouch;
    }

    public int getMegaTorchBurnoutRate() {
        return this.megaTorchBurnoutRate;
    }

    public int getMegaTorchBurnoutValue() {
        return this.megaTorchBurnoutValue;
    }
}

