/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.carving;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.common.carving.GroupList;

@ParametersAreNonnullByDefault
public class Carving
implements ICarvingRegistry {
    GroupList groups = new GroupList();
    public static final ICarvingRegistry chisel = new Carving();
    public static final Carving needle = new Carving();

    public static void construct() {
    }

    private Carving() {
    }

    @Override
    @Nullable
    public ICarvingVariation getVariation(IBlockState state) {
        return this.getVariation(state, this.getGroup(state));
    }

    @Override
    @Nullable
    public ICarvingVariation getVariation(ItemStack stack) {
        return this.getVariation(stack, this.getGroup(stack));
    }

    @Nullable
    private ICarvingVariation getVariation(IBlockState state, @Nullable ICarvingGroup group) {
        if (group != null) {
            for (ICarvingVariation v : group.getVariations()) {
                if (!v.getBlockState().equals(state)) continue;
                return v;
            }
        }
        return null;
    }

    @Nullable
    private ICarvingVariation getVariation(ItemStack stack, @Nullable ICarvingGroup group) {
        if (group != null) {
            for (ICarvingVariation v : group.getVariations()) {
                if (!stack.func_77969_a(v.getStack()) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)v.getStack())) continue;
                return v;
            }
        }
        return null;
    }

    @Override
    public List<ICarvingVariation> getGroupVariations(IBlockState state) {
        ICarvingGroup group = this.getGroup(state);
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getVariations();
    }

    @Override
    @Nullable
    public String getOreName(IBlockState state) {
        ICarvingGroup group = this.getGroup(state);
        if (group == null) {
            return null;
        }
        return group.getOreName();
    }

    @Override
    public List<ItemStack> getItemsForChiseling(ItemStack chiseledItem) {
        ICarvingGroup group = null;
        group = this.getGroup(chiseledItem);
        if (group == null) {
            return Collections.emptyList();
        }
        return this.getItemsForChiseling(group);
    }

    @Override
    public List<ItemStack> getItemsForChiseling(ICarvingGroup group) {
        List ores;
        String oreName;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        List<ICarvingVariation> variations = group.getVariations();
        ArrayList found = Lists.newArrayList();
        if (!group.getVariations().isEmpty()) {
            for (ICarvingVariation v : variations) {
                this.addNewStackToList(v.getStack(), items, found);
            }
        }
        if ((oreName = group.getOreName()) != null && (ores = OreDictionary.getOres((String)oreName)) != null) {
            for (ItemStack stack : ores) {
                this.addNewStackToList(stack, items, found);
            }
        }
        return items;
    }

    private void addNewStackToList(ItemStack stack, List<ItemStack> list, List<ItemStackWrapper> found) {
        ItemStackWrapper wrapper = new ItemStackWrapper(stack);
        if (!found.contains(wrapper)) {
            list.add(stack);
            found.add(wrapper);
        }
    }

    @Override
    @Nullable
    public ICarvingGroup getGroup(IBlockState state) {
        ICarvingVariation variation = this.getVariation(state, this.groups.getGroup(state));
        ItemStack stack = variation == null ? new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state)) : variation.getStack();
        ICarvingGroup ore = this.getOreGroup(stack);
        return ore == null ? this.groups.getGroup(state) : ore;
    }

    @Override
    @Nullable
    public ICarvingGroup getGroup(ItemStack stack) {
        ICarvingGroup ore = this.getOreGroup(stack);
        return ore == null ? this.groups.getGroup(stack) : ore;
    }

    @Nullable
    private ICarvingGroup getOreGroup(@Nullable ItemStack stack) {
        int[] ids;
        if (stack != null && (ids = OreDictionary.getOreIDs((ItemStack)stack)).length > 0) {
            for (int id : ids) {
                ICarvingGroup oreGroup = this.groups.getGroupByOre(OreDictionary.getOreName((int)id));
                if (oreGroup == null) continue;
                return oreGroup;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public ICarvingGroup getGroup(String name) {
        return this.groups.getGroupByName(name);
    }

    @Override
    @Nullable
    public ICarvingGroup removeGroup(String groupName) {
        ICarvingGroup g = this.groups.getGroupByName(groupName);
        return this.groups.remove(g) ? g : null;
    }

    @Override
    @Nullable
    public ICarvingVariation removeVariation(IBlockState state) {
        ICarvingGroup group = this.getGroup(state);
        if (group == null) {
            return null;
        }
        return this.removeVariation(state, group.getName());
    }

    @Override
    @Nullable
    public ICarvingVariation removeVariation(IBlockState state, String group) {
        return this.groups.removeVariation(state, group);
    }

    @Override
    public void addVariation(String groupName, IBlockState state, int order) {
        ICarvingVariation variation = CarvingUtils.getDefaultVariationFor(state, order);
        this.addVariation(groupName, variation);
    }

    @Override
    public void addVariation(String groupName, ICarvingVariation variation) {
        ICarvingGroup group = this.groups.getGroupByName(groupName);
        if (group == null) {
            group = CarvingUtils.getDefaultGroupFor(groupName);
            this.addGroup(group);
        }
        this.groups.addVariation(groupName, variation);
    }

    @Override
    public void addGroup(ICarvingGroup group) {
        this.groups.add(group);
    }

    @Override
    public void registerOre(String name, String oreName) {
        ICarvingGroup group = this.groups.getGroupByName(name);
        if (group == null) {
            throw new NullPointerException("Cannot register ore name for group " + name + ", as it does not exist.");
        }
        group.setOreName(oreName);
    }

    @Override
    public void setVariationSound(String name, String sound) {
        ICarvingGroup group = this.groups.getGroupByName(name);
        if (group == null) {
            throw new NullPointerException("Cannot set sound for group " + name + ", as it does not exist.");
        }
        group.setSound(sound);
    }

    @Override
    public String getVariationSound(IBlockState state) {
        ICarvingGroup group = this.groups.getGroup(state);
        return this.getSound(group);
    }

    @Override
    public String getVariationSound(ItemStack stack) {
        ICarvingGroup group = this.groups.getGroup(stack);
        return this.getSound(group);
    }

    @Override
    public String getVariationSound(@Nullable ICarvingVariation variation) {
        ICarvingGroup group = variation == null ? null : this.groups.getGroup(variation);
        return this.getSound(group);
    }

    private String getSound(@Nullable ICarvingGroup group) {
        String sound = group == null ? null : group.getSound();
        return sound == null ? "chisel:chisel.fallback" : sound;
    }

    @Override
    public List<String> getSortedGroupNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.groups.getNames());
        Collections.sort(names);
        return names;
    }

    static {
        CarvingUtils.chisel = chisel;
    }

    private static class ItemStackWrapper {
        @Nullable
        private ItemStack wrapped;

        private ItemStackWrapper(@Nullable ItemStack stack) {
            this.wrapped = stack;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemStackWrapper other = (ItemStackWrapper)obj;
            if (this.wrapped == null) {
                return other.wrapped == null;
            }
            return ItemStack.func_77989_b((ItemStack)this.wrapped, (ItemStack)other.wrapped) && ItemStack.func_77970_a((ItemStack)this.wrapped, (ItemStack)other.wrapped);
        }
    }
}

