/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.carving;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;

@ParametersAreNonnullByDefault
public class CarvingUtils {
    @Nullable
    public static ICarvingRegistry chisel;

    public static int compare(ICarvingVariation v1, ICarvingVariation v2) {
        return v1.getOrder() - v2.getOrder();
    }

    @Deprecated
    public static ItemStack getStack(ICarvingVariation variation) {
        return variation.getStack();
    }

    @Nullable
    public static ICarvingRegistry getChiselRegistry() {
        return chisel;
    }

    public static ICarvingVariation getDefaultVariationFor(IBlockState state, int order) {
        return new SimpleCarvingVariation(state, order);
    }

    public static ICarvingGroup getDefaultGroupFor(String name) {
        return new SimpleCarvingGroup(name);
    }

    private static class SimpleCarvingGroup
    implements ICarvingGroup {
        private String name;
        @Nullable
        private String sound;
        @Nullable
        private String oreName;
        private List<ICarvingVariation> variations = Lists.newArrayList();

        public SimpleCarvingGroup(String name) {
            this.name = name;
        }

        @Override
        public List<ICarvingVariation> getVariations() {
            return Lists.newArrayList(this.variations);
        }

        @Override
        public void addVariation(ICarvingVariation variation) {
            this.variations.add(variation);
            Collections.sort(this.variations, new Comparator<ICarvingVariation>(){

                @Override
                public int compare(ICarvingVariation o1, ICarvingVariation o2) {
                    return CarvingUtils.compare(o1, o2);
                }
            });
        }

        @Override
        public boolean removeVariation(ICarvingVariation variation) {
            ICarvingVariation toRemove = null;
            for (ICarvingVariation v : this.variations) {
                if (!v.getBlockState().equals(variation.getBlockState())) continue;
                toRemove = v;
            }
            return toRemove == null ? false : this.variations.remove(toRemove);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getSound() {
            return this.sound;
        }

        @Override
        public void setSound(@Nullable String sound) {
            this.sound = sound;
        }

        @Override
        @Nullable
        public String getOreName() {
            return this.oreName;
        }

        @Override
        public void setOreName(@Nullable String oreName) {
            this.oreName = oreName;
        }
    }

    private static class SimpleCarvingVariation
    implements ICarvingVariation {
        private int order;
        private IBlockState state;

        public SimpleCarvingVariation(IBlockState state, int order) {
            this.order = order;
            this.state = state;
        }

        @Override
        public Block getBlock() {
            return this.state.func_177230_c();
        }

        @Override
        public IBlockState getBlockState() {
            return this.state;
        }

        @Override
        public ItemStack getStack() {
            return new ItemStack(this.state.func_177230_c(), 1, this.state.func_177230_c().func_176201_c(this.state));
        }

        @Override
        public int getOrder() {
            return this.order;
        }
    }
}

