/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power.tesla;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraftforge.energy.IEnergyStorage;

public class TeslaToForgeAdapter
implements IEnergyStorage {
    private ITeslaHolder capHolder;
    private ITeslaConsumer capConsumer;
    private ITeslaProducer capProducer;

    public TeslaToForgeAdapter(ITeslaHolder capHolder, ITeslaConsumer capConsumer, ITeslaProducer capProducer) {
        this.capHolder = capHolder;
        this.capConsumer = capConsumer;
        this.capProducer = capProducer;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.capConsumer != null) {
            return (int)this.capConsumer.givePower((long)maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.capProducer != null) {
            return (int)this.capProducer.takePower((long)maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored() {
        if (this.capHolder != null) {
            return (int)this.capHolder.getStoredPower();
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        if (this.capHolder != null) {
            return (int)this.capHolder.getCapacity();
        }
        return 0;
    }

    public boolean canExtract() {
        return this.capProducer != null;
    }

    public boolean canReceive() {
        return this.capConsumer != null;
    }
}

