/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.paint;

import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.paint.PaintSourceParser;
import crazypants.enderio.paint.PainterUtil2;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.item.ItemStack;

public class PaintSourceValidator {
    public static PaintSourceValidator instance = new PaintSourceValidator();
    private final List<RecipeInput> whitelist = new ArrayList<RecipeInput>();
    private final List<RecipeInput> blacklist = new ArrayList<RecipeInput>();

    public boolean isValidSourceDefault(ItemStack paintSource) {
        if (paintSource == null) {
            return false;
        }
        Block block = PainterUtil2.getBlockFromItem(paintSource);
        if (block == null) {
            return false;
        }
        if (this.isBlacklisted(paintSource)) {
            return false;
        }
        if (this.isWhitelisted(paintSource)) {
            return true;
        }
        return Config.allowTileEntitiesAsPaintSource || !(block instanceof ITileEntityProvider);
    }

    public boolean isWhitelisted(ItemStack paintSource) {
        return this.isInList(paintSource, this.whitelist);
    }

    public boolean isBlacklisted(ItemStack paintSource) {
        return this.isInList(paintSource, this.blacklist);
    }

    public void addToWhitelist(ItemStack input) {
        this.addToWhitelist(new RecipeInput(input, true));
    }

    public void addToWhitelist(RecipeInput input) {
        this.whitelist.add(input);
    }

    public void addToBlacklist(ItemStack input) {
        this.addToBlacklist(new RecipeInput(input, true));
    }

    public void addToBlacklist(RecipeInput input) {
        this.blacklist.add(input);
    }

    public void removeFromWhitelist(RecipeInput input) {
        this.removeFromList(input, this.whitelist);
    }

    public void removeFromBlackList(RecipeInput input) {
        this.removeFromList(input, this.blacklist);
    }

    protected boolean isInList(ItemStack paintSource, List<RecipeInput> list) {
        if (paintSource == null) {
            return false;
        }
        for (RecipeInput ri : list) {
            if (ri == null || !ri.isInput(paintSource)) continue;
            return true;
        }
        return false;
    }

    protected void removeFromList(RecipeInput input, List<RecipeInput> list) {
        ItemStack inStack = input.getInput();
        if (inStack == null) {
            return;
        }
        RecipeInput toRemove = null;
        for (RecipeInput in : list) {
            if (!ItemUtil.areStacksEqual((ItemStack)inStack, (ItemStack)in.getInput())) continue;
            toRemove = in;
            break;
        }
        if (toRemove != null) {
            list.remove(toRemove);
        }
    }

    public void loadConfig() {
        PaintSourceParser.loadConfig();
    }
}

