/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material.fusedQuartz;

import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.painter.blocks.BlockItemPaintedBlock;
import crazypants.enderio.material.fusedQuartz.FusedQuartzType;
import crazypants.enderio.render.ICustomItemResourceLocation;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFusedQuartzBase<T extends TileEntityEio>
extends BlockEio<T>
implements ISmartRenderAwareBlock,
BlockItemPaintedBlock.INamedSubBlocks {
    public BlockFusedQuartzBase(@Nonnull String name, Class<T> teClass) {
        super(name, teClass, Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(EnderIOTab.tabEnderIO);
    }

    protected ItemBlock createItemBlock() {
        return new BlockItemFusedQuartzBase((Block)this, this.getName());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FusedQuartzType.KIND, (Comparable)((Object)FusedQuartzType.getTypeFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return FusedQuartzType.getMetaFromType((FusedQuartzType)((Object)state.func_177229_b(FusedQuartzType.KIND)));
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity par1Entity, Explosion explosion) {
        if (((FusedQuartzType)((Object)world.func_180495_p(pos).func_177229_b(FusedQuartzType.KIND))).isBlastResistant()) {
            return 1200.0f;
        }
        return super.func_149638_a(par1Entity);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_149717_k(IBlockState state) {
        return ((FusedQuartzType)((Object)state.func_177229_b(FusedQuartzType.KIND))).getLightOpacity();
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        return ((FusedQuartzType)((Object)state.func_177229_b(FusedQuartzType.KIND))).isEnlightened() ? 15 : super.func_149750_m(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        if (par2CreativeTabs != null) {
            for (FusedQuartzType fqt : FusedQuartzType.values()) {
                par3List.add(new ItemStack(par1, 1, fqt.ordinal()));
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean shouldWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public String getUnlocalizedName(int meta) {
        FusedQuartzType type = FusedQuartzType.getTypeFromMeta(meta);
        return "enderio.blockFusedQuartz." + type.getUnlocalisedName();
    }

    public static class BlockItemFusedQuartzBase
    extends BlockItemPaintedBlock
    implements ICustomItemResourceLocation {
        public BlockItemFusedQuartzBase(Block block, String name) {
            super(block, name);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
            super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
            FusedQuartzType type = this.determineQuartzType(par1ItemStack);
            if (type.isBlastResistant()) {
                par3List.add(EnderIO.lang.localize("blastResistant"));
            }
            if (type.isEnlightened()) {
                par3List.add(EnderIO.lang.localize("lightEmitter"));
            }
            if (type.getLightOpacity() > 0) {
                par3List.add(EnderIO.lang.localize("lightBlocker"));
            }
        }

        @SideOnly(value=Side.CLIENT)
        protected FusedQuartzType determineQuartzType(ItemStack par1ItemStack) {
            int meta = par1ItemStack.func_77952_i();
            FusedQuartzType type = FusedQuartzType.getTypeFromMeta(meta);
            return type;
        }

        @Override
        @Nonnull
        public ResourceLocation getRegistryNameForCustomModelResourceLocation() {
            return ModObject.blockFusedQuartz.getItem().getRegistryName();
        }
    }
}

