/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorDataItem;
import crazypants.enderio.render.IHaveRenderers;
import crazypants.util.ClientUtil;
import crazypants.util.NbtValue;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCapacitor
extends Item
implements ICapacitorDataItem,
IHaveRenderers {
    public static ItemCapacitor create() {
        ItemCapacitor result = new ItemCapacitor();
        result.init();
        return result;
    }

    protected ItemCapacitor() {
        this.func_77637_a(EnderIOTab.tabEnderIOMaterials);
        this.func_77655_b(ModObject.itemBasicCapacitor.getUnlocalisedName());
        this.setRegistryName(ModObject.itemBasicCapacitor.getUnlocalisedName());
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        ResourceLocation[] resourceLocations = DefaultCapacitorData.getResourceLocations();
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])resourceLocations);
        for (int i = 0; i < resourceLocations.length; ++i) {
            ClientUtil.regRenderer((Item)this, i, resourceLocations[i]);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.getCapacitorData(stack).getUnlocalizedName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        for (int j = 0; j < DefaultCapacitorData.values().length - 1; ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    public int getMetadata(ItemStack stack) {
        return MathHelper.func_76125_a((int)(stack != null ? stack.func_77952_i() : 0), (int)0, (int)(DefaultCapacitorData.values().length - 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        if (this.getMetadata(stack) > 0) {
            par3List.add(EnderIO.lang.localize("machine.tooltip.upgrade"));
            if (SpecialTooltipHandler.showAdvancedTooltips()) {
                SpecialTooltipHandler.addDetailedTooltipFromResources(par3List, (String)"enderio.machine.tooltip.upgrade");
            } else {
                SpecialTooltipHandler.addShowDetailsTooltip(par3List);
            }
        }
        if (NbtValue.GLINT.hasTag(stack)) {
            par3List.add(EnderIO.lang.localize("loot.capacitor.entry." + NbtValue.CAPNO.getInt(stack), new Object[]{NbtValue.CAPNAME.getString(stack, "(!%$&\u00a7*&%*???")}));
        }
    }

    @Override
    public ICapacitorData getCapacitorData(ItemStack stack) {
        return DefaultCapacitorData.values()[this.getMetadata(stack)];
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || NbtValue.GLINT.hasTag(stack);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K || System.getProperty("INDEV") == null) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            chest.func_174888_l();
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)world);
            if (player != null) {
                lootcontext$builder.func_186469_a(player.func_184817_da());
            }
            LootTable loottable = world.func_184146_ak().func_186521_a(LootTableList.field_186431_m);
            loottable.func_186460_a((IInventory)chest, world.field_73012_v, lootcontext$builder.func_186471_a());
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }
}

