/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.slicensplice;

import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.recipe.IManyToOneRecipe;
import crazypants.enderio.machine.recipe.ManyToOneMachineRecipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.paint.IPaintable;
import info.loenwind.autosave.annotations.Storable;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;

@Storable
public class TileSliceAndSplice
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    protected static final int axeIndex = 6;
    protected static final int shearsIndex = 7;
    private EntityLivingBase fakePlayer;

    public TileSliceAndSplice() {
        super(new SlotDefinition(8, 1), CapacitorKey.SLICE_POWER_INTAKE, CapacitorKey.SLICE_POWER_BUFFER, CapacitorKey.SLICE_POWER_USE);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockSliceAndSplice.getUnlocalisedName();
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        if (this.getAxe() == null || this.getShears() == null) {
            return null;
        }
        return super.canStartNextTask(chance);
    }

    private ItemStack getAxe() {
        return this.inventory[6];
    }

    private ItemStack getShears() {
        return this.inventory[7];
    }

    @Override
    protected void taskComplete() {
        super.taskComplete();
        this.damageTool(this.getAxe(), 6);
        this.damageTool(this.getShears(), 7);
    }

    private void damageTool(ItemStack tool, int toolIndex) {
        if (tool != null && tool.func_77984_f()) {
            tool.func_77972_a(1, this.getFakePlayer());
            if (tool.func_77952_i() >= tool.func_77958_k()) {
                this.inventory[toolIndex] = null;
            }
        }
    }

    private EntityLivingBase getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.field_145850_b.field_73011_w.getDimension()));
        }
        return this.fakePlayer;
    }

    @Override
    protected MachineRecipeInput[] getRecipeInputs() {
        MachineRecipeInput[] res = new MachineRecipeInput[this.slotDefinition.getNumInputSlots() - 2];
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < res.length; ++i) {
            res[i] = new MachineRecipeInput(fromSlot, this.inventory[fromSlot]);
            ++fromSlot;
        }
        return res;
    }

    @Override
    public boolean isMachineItemValidForSlot(int slot, ItemStack itemstack) {
        if (itemstack == null || itemstack.func_77973_b() == null) {
            return false;
        }
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        if (slot == 6) {
            return itemstack.func_77973_b() instanceof ItemAxe;
        }
        if (slot == 7) {
            return itemstack.func_77973_b() instanceof ItemShears;
        }
        ItemStack currentStackInSlot = this.inventory[slot];
        if (currentStackInSlot != null) {
            return currentStackInSlot.func_77969_a(itemstack);
        }
        int numSlotsFilled = 0;
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (i < 0 || i >= this.inventory.length || i == 6 || i == 7 || this.inventory[i] == null || this.inventory[i].field_77994_a <= 0) continue;
            ++numSlotsFilled;
        }
        List<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineName(), MachineRecipeInput.create(slot, itemstack));
        if (numSlotsFilled == 0 && !recipes.isEmpty()) {
            return true;
        }
        return this.isValidInputForAlloyRecipe(slot, itemstack, numSlotsFilled, recipes);
    }

    private boolean isValidInputForAlloyRecipe(int slot, ItemStack itemstack, int numSlotsFilled, List<IMachineRecipe> recipes) {
        ItemStack[] resultInv = new ItemStack[this.slotDefinition.getNumInputSlots()];
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (i < 0 || i >= this.inventory.length || i == 6 || i == 7) continue;
            resultInv[i] = i == slot ? itemstack : this.inventory[i];
        }
        for (IMachineRecipe recipe : recipes) {
            if (!(recipe instanceof ManyToOneMachineRecipe)) continue;
            block2: for (IManyToOneRecipe oneRecipe : ((ManyToOneMachineRecipe)recipe).getRecipesThatHaveTheseAsValidRecipeComponents(resultInv)) {
                for (int i = 0; i < resultInv.length; ++i) {
                    if (resultInv[i] == null) continue;
                    for (RecipeInput ri : oneRecipe.getInputs()) {
                        if (ri.getSlotNumber() == i && !ri.isInput(resultInv[i])) continue block2;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

