/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.fluid.SmartTank;
import crazypants.enderio.machine.reservoir.ReservoirBlockRenderMapper;
import crazypants.enderio.machine.reservoir.ReservoirItemRenderMapper;
import crazypants.enderio.machine.reservoir.ReservoirRenderer;
import crazypants.enderio.machine.reservoir.TileReservoir;
import crazypants.enderio.render.IHaveTESR;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReservoir
extends BlockEio<TileReservoir>
implements IResourceTooltipProvider,
ISmartRenderAwareBlock,
IHaveTESR {
    @SideOnly(value=Side.CLIENT)
    private static ReservoirItemRenderMapper RENDER_MAPPER;

    public static BlockReservoir create() {
        BlockReservoir result = new BlockReservoir();
        result.init();
        return result;
    }

    private BlockReservoir() {
        super(ModObject.blockReservoir.getUnlocalisedName(), TileReservoir.class, new Material(MapColor.field_151662_n){

            public boolean func_76229_l() {
                return false;
            }
        });
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO)));
    }

    protected void init() {
        super.init();
        SmartModelAttacher.register((Block)this, EnumMergingBlockRenderMode.RENDER, EnumMergingBlockRenderMode.DEFAULTS, EnumMergingBlockRenderMode.AUTO);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumMergingBlockRenderMode.RENDER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO));
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            ReservoirBlockRenderMapper renderMapper = new ReservoirBlockRenderMapper(state, world, pos);
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, renderMapper);
            blockStateWrapper.addCacheKey(renderMapper);
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return ReservoirItemRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!entityPlayer.func_70093_af() && entityPlayer.field_71071_by.func_70448_g() != null && (te = world.func_175625_s(pos)) instanceof TileReservoir) {
            TileReservoir tank = (TileReservoir)te;
            if (ToolUtil.isToolEquipped(entityPlayer, hand)) {
                tank.setAutoEject(!tank.isAutoEject());
                world.func_184138_a(pos, state, state, 3);
                return true;
            }
            if (tank.tank.getAvailableSpace() >= 1000 && FluidUtil.fillInternalTankFromPlayerHandItem((World)world, (BlockPos)pos, (EntityPlayer)entityPlayer, (EnumHand)hand, (ITankAccess)tank)) {
                return true;
            }
            if (!tank.tank.isFull() && FluidUtil.fillInternalTankFromPlayerHandItem((World)world, (BlockPos)pos, (EntityPlayer)entityPlayer, (EnumHand)hand, (ITankAccess)new TankWrapper((ITankAccess)tank, world, pos))) {
                return true;
            }
            if (FluidUtil.fillPlayerHandItemFromInternalTank((World)world, (BlockPos)pos, (EntityPlayer)entityPlayer, (EnumHand)hand, (ITankAccess)tank)) {
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, entityPlayer, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    @Nonnull
    public TileEntity createTileEntity(World world, IBlockState metadata) {
        return new TileReservoir();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState bs, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return !(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof BlockReservoir);
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_149739_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileReservoir.class, (TileEntitySpecialRenderer)new ReservoirRenderer((BlockReservoir)ModObject.blockReservoir.getBlock()));
    }

    private static class TankWrapper
    implements ITankAccess {
        private final List<ITankAccess> parents = new ArrayList<ITankAccess>();
        private SmartTank tank;
        private final World world;
        private final BlockPos pos;

        private TankWrapper(ITankAccess parent, World world, BlockPos pos) {
            this.parents.add(parent);
            this.world = world;
            this.pos = pos;
        }

        public FluidTank getInputTank(FluidStack forFluidType) {
            FluidTank parentTank = this.parents.get(0).getInputTank(forFluidType);
            if (parentTank == null) {
                return null;
            }
            int free = parentTank.getCapacity() - parentTank.getFluidAmount();
            for (EnumFacing face : EnumFacing.values()) {
                FluidTank tank2;
                TileEntity neighbor = this.world.func_175625_s(this.pos.func_177972_a(face));
                if (!(neighbor instanceof ITankAccess) || (tank2 = ((ITankAccess)neighbor).getInputTank(forFluidType)) == null) continue;
                free += tank2.getCapacity() - tank2.getFluidAmount();
                this.parents.add((ITankAccess)neighbor);
            }
            if (free < 1000) {
                free = 1000;
            }
            this.tank = new SmartTank(parentTank.getFluid(), free);
            return this.tank;
        }

        public FluidTank[] getOutputTanks() {
            return this.parents.get(0).getOutputTanks();
        }

        public void setTanksDirty() {
            FluidStack stack = this.tank.getFluid();
            if (stack.amount > 0) {
                for (ITankAccess parent : this.parents) {
                    FluidTank ptank = parent.getInputTank(stack);
                    stack.amount -= ptank.fill(stack, true);
                    parent.setTanksDirty();
                    if (stack.amount > 0) continue;
                    return;
                }
            }
            this.tank.setCapacity(0);
        }
    }
}

