/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketItemInfo
implements IMessage,
IMessageHandler<PacketItemInfo, IMessage> {
    private int windowId;
    private int generation;
    private byte[] compressed;

    public PacketItemInfo() {
    }

    public PacketItemInfo(int windowId, InventoryDatabaseServer db, List<ItemEntry> items) {
        this.windowId = windowId;
        this.generation = db.generation;
        try {
            this.compressed = db.compressItemInfo(items);
        }
        catch (IOException ex) {
            Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while compressing items", ex);
            this.compressed = new byte[0];
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.generation = buf.readInt();
        this.compressed = NetworkUtil.readByteArray((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeInt(this.generation);
        NetworkUtil.writeByteArray((ByteBuf)buf, (byte[])this.compressed);
    }

    public IMessage onMessage(PacketItemInfo message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        if (player.field_71070_bA.field_75152_c == message.windowId && player.field_71070_bA instanceof InventoryPanelContainer) {
            InventoryPanelContainer ipc = (InventoryPanelContainer)player.field_71070_bA;
            TileInventoryPanel teInvPanel = (TileInventoryPanel)ipc.getInv();
            InventoryDatabaseClient db = teInvPanel.getDatabaseClient(message.generation);
            try {
                db.readCompressedItems(message.compressed);
            }
            catch (IOException ex) {
                Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while reading item info", ex);
            }
        }
        return null;
    }
}

