/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import crazypants.util.Prep;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class FarmersCommune
implements IFarmerJoe {
    public static FarmersCommune instance = new FarmersCommune();
    private static List<ItemStack> disableTrees = new ArrayList<ItemStack>();
    private List<IFarmerJoe> farmers = new ArrayList<IFarmerJoe>();

    public static void joinCommune(IFarmerJoe joe) {
        CustomSeedFarmer customSeedFarmer;
        if (joe instanceof CustomSeedFarmer && (customSeedFarmer = (CustomSeedFarmer)joe).doesDisableTreeFarm()) {
            disableTrees.add(customSeedFarmer.getSeeds());
        }
        FarmersCommune.instance.farmers.add(joe);
    }

    public static void leaveCommune(IFarmerJoe joe) {
        throw new UnsupportedOperationException("As if this would be implemented. The commune is for life!");
    }

    private FarmersCommune() {
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        for (IFarmerJoe joe : this.farmers) {
            if (!joe.canHarvest(farm, bc, block, meta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        for (IFarmerJoe joe : this.farmers) {
            if (this.ignoreTreeHarvest(farm, bc, joe) || !joe.canHarvest(farm, bc, block, meta)) continue;
            return joe.harvestBlock(farm, bc, block, meta);
        }
        return null;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        for (IFarmerJoe joe : this.farmers) {
            if (!joe.prepareBlock(farm, bc, block, meta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        for (IFarmerJoe joe : this.farmers) {
            if (!joe.canPlant(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreTreeHarvest(TileFarmStation farm, BlockPos bc, IFarmerJoe joe) {
        ItemStack stack = farm.getSeedTypeInSuppliesFor(bc);
        if (!(joe instanceof TreeFarmer) || Prep.isInvalid(stack)) {
            return false;
        }
        for (ItemStack disableTreeStack : disableTrees) {
            if (!disableTreeStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }
}

