/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.FarmNotification;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.util.Prep;
import crazypants.util.Things;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomSeedFarmer
implements IFarmerJoe {
    protected Block plantedBlock;
    protected int plantedBlockMeta;
    protected int grownBlockMeta;
    protected ItemStack seeds;
    protected boolean requiresFarmland = true;
    protected Things tilledBlocks = new Things(new String[0]);
    protected boolean ignoreSustainCheck = false;
    protected boolean checkGroundForFarmland = false;
    protected boolean disableTreeFarm;

    public CustomSeedFarmer(Block plantedBlock, ItemStack seeds) {
        this(plantedBlock, 0, 7, seeds);
    }

    public CustomSeedFarmer(Block plantedBlock, int grownBlockMeta, ItemStack seeds) {
        this(plantedBlock, 0, grownBlockMeta, seeds);
    }

    public CustomSeedFarmer(Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, ItemStack seeds) {
        this.plantedBlock = plantedBlock;
        this.plantedBlockMeta = plantedBlockMeta;
        this.grownBlockMeta = grownBlockMeta;
        this.seeds = seeds;
        FarmStationContainer.slotItemsSeeds.add(seeds);
        this.addTilledBlock(Blocks.field_150458_ak);
    }

    public void clearTilledBlocks() {
        this.tilledBlocks = new Things(new String[0]);
    }

    public void addTilledBlock(Things block) {
        this.tilledBlocks.add(block);
    }

    public void addTilledBlock(Block block) {
        this.tilledBlocks.add(block);
    }

    public boolean isIgnoreGroundCanSustainCheck() {
        return this.ignoreSustainCheck;
    }

    public void setIgnoreGroundCanSustainCheck(boolean ignoreSustainCheck) {
        this.ignoreSustainCheck = ignoreSustainCheck;
    }

    public boolean isCheckGroundForFarmland() {
        return this.checkGroundForFarmland;
    }

    public void setCheckGroundForFarmland(boolean checkGroundForFarmland) {
        this.checkGroundForFarmland = checkGroundForFarmland;
    }

    public int getPlantedBlockMeta() {
        return this.plantedBlockMeta;
    }

    public Block getPlantedBlock() {
        return this.plantedBlock;
    }

    public ItemStack getSeeds() {
        return this.seeds;
    }

    public int getFullyGrownBlockMeta() {
        return this.grownBlockMeta;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockPos bc, Block block, IBlockState bs) {
        int meta = bs.func_177230_c().func_176201_c(bs);
        return block == this.getPlantedBlock() && this.getFullyGrownBlockMeta() == meta;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        return stack.func_77969_a(this.getSeeds());
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        if (!farm.isOpen(bc)) {
            return false;
        }
        if (this.requiresFarmland()) {
            boolean tilled;
            if (this.isGroundTilled(farm, bc)) {
                return this.plantFromInventory(farm, bc);
            }
            if (farm.hasSeed(this.getSeeds(), bc) && !(tilled = this.tillBlock(farm, bc))) {
                return false;
            }
        }
        return this.plantFromInventory(farm, bc);
    }

    public boolean requiresFarmland() {
        return this.requiresFarmland;
    }

    public void setRequiresFarmland(boolean requiresFarmland) {
        this.requiresFarmland = requiresFarmland;
    }

    protected boolean plantFromInventory(TileFarmStation farm, BlockPos bc) {
        World worldObj = farm.func_145831_w();
        if (this.canPlant(farm, worldObj, bc) && farm.takeSeedFromSupplies(this.getSeeds(), bc) != null) {
            return this.plant(farm, worldObj, bc);
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        if (!this.canHarvest(farm, bc, block, meta)) {
            return null;
        }
        if (!farm.hasHoe()) {
            farm.setNotification(FarmNotification.NO_HOE);
            return null;
        }
        World worldObj = farm.func_145831_w();
        EntityPlayerMP fakePlayer = farm.getFakePlayer();
        int fortune = farm.getMaxLootingValue();
        ArrayList<EntityItem> result = new ArrayList<EntityItem>();
        List drops = block.getDrops((IBlockAccess)worldObj, bc, meta, fortune);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldObj, (BlockPos)bc, (IBlockState)meta, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
        farm.damageHoe(1, bc);
        farm.actionPerformed(false);
        boolean removed = false;
        if (drops != null) {
            for (ItemStack stack : drops) {
                if (!(worldObj.field_73012_v.nextFloat() <= chance)) continue;
                if (!removed && stack.func_77969_a(this.getSeeds())) {
                    --stack.field_77994_a;
                    removed = true;
                    if (stack.field_77994_a <= 0) continue;
                    result.add(new EntityItem(worldObj, (double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5, stack.func_77946_l()));
                    continue;
                }
                result.add(new EntityItem(worldObj, (double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5, stack.func_77946_l()));
            }
        }
        ItemStack[] inv = fakePlayer.field_71071_by.field_70462_a;
        for (int slot = 0; slot < inv.length; ++slot) {
            ItemStack stack = inv[slot];
            if (!Prep.isValid(stack)) continue;
            inv[slot] = Prep.getEmpty();
            EntityItem entityitem = new EntityItem(worldObj, (double)bc.func_177958_n() + 0.5, (double)(bc.func_177956_o() + 1), (double)bc.func_177952_p() + 0.5, stack);
            result.add(entityitem);
        }
        if (removed) {
            if (!this.plant(farm, worldObj, bc)) {
                result.add(new EntityItem(worldObj, (double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5, this.getSeeds().func_77946_l()));
                worldObj.func_180501_a(bc, Blocks.field_150350_a.func_176223_P(), 3);
            }
        } else {
            worldObj.func_180501_a(bc, Blocks.field_150350_a.func_176223_P(), 3);
        }
        return new HarvestResult(result, bc);
    }

    protected boolean tillBlock(TileFarmStation farm, BlockPos plantingLocation) {
        World worldObj = farm.func_145831_w();
        BlockPos dirtLoc = plantingLocation.func_177977_b();
        Block dirtBlock = farm.getBlock(dirtLoc);
        if ((dirtBlock == Blocks.field_150346_d || dirtBlock == Blocks.field_150349_c) && farm.hasHoe()) {
            farm.damageHoe(1, dirtLoc);
            worldObj.func_175656_a(dirtLoc, Blocks.field_150458_ak.func_176223_P());
            SoundType soundType = Blocks.field_150458_ak.getSoundType(Blocks.field_150458_ak.func_176223_P(), worldObj, dirtLoc, null);
            worldObj.func_184134_a((double)((float)dirtLoc.func_177958_n() + 0.5f), (double)((float)dirtLoc.func_177956_o() + 0.5f), (double)((float)dirtLoc.func_177952_p() + 0.5f), soundType.func_185844_d(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    protected boolean isGroundTilled(TileFarmStation farm, BlockPos plantingLocation) {
        return this.tilledBlocks.contains(farm.getBlock(plantingLocation.func_177977_b()));
    }

    protected boolean canPlant(TileFarmStation farm, World worldObj, BlockPos bc) {
        Block target = this.getPlantedBlock();
        BlockPos groundPos = bc.func_177977_b();
        IBlockState bs = worldObj.func_180495_p(groundPos);
        Block ground = bs.func_177230_c();
        IPlantable plantable = (IPlantable)this.getPlantedBlock();
        return !(!target.func_176196_c(worldObj, bc) || !ground.canSustainPlant(bs, (IBlockAccess)worldObj, groundPos, EnumFacing.UP, plantable) && !this.ignoreSustainCheck || this.checkGroundForFarmland && !this.isGroundTilled(farm, bc));
    }

    protected boolean plant(TileFarmStation farm, World worldObj, BlockPos bc) {
        worldObj.func_180501_a(bc, Blocks.field_150350_a.func_176223_P(), 3);
        if (this.canPlant(farm, worldObj, bc)) {
            worldObj.func_180501_a(bc, this.getPlantedBlock().func_176203_a(this.getPlantedBlockMeta()), 3);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    public boolean doesDisableTreeFarm() {
        return this.disableTreeFarm;
    }
}

