/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.machine.buffer.BufferType;
import crazypants.enderio.machine.buffer.TileBuffer;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.power.AbstractPoweredBlockItem;
import crazypants.enderio.power.ItemPowerCapabilityBackend;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockItemBuffer
extends AbstractPoweredBlockItem
implements EnderCoreMethods.IOverlayRenderAware {
    public BlockItemBuffer(Block block, String name) {
        super(block, 0, 0, 0);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.setRegistryName(name);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        return BufferType.values()[stack.func_77952_i()].getUnlocalizedName();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        TileEntity te;
        super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (newState.func_177230_c() == this.field_150939_a && (te = world.func_175625_s(pos)) instanceof TileBuffer) {
            TileBuffer buffer = (TileBuffer)te;
            BufferType t = BufferType.values()[this.field_150939_a.func_176201_c(newState)];
            buffer.setHasInventory(t.hasInventory);
            buffer.setHasPower(t.hasPower);
            buffer.setCreative(t.isCreative);
            buffer.func_70296_d();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        tooltip.add(PainterUtil2.getTooltTipText(stack));
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        if (stack.field_77994_a == 1 && ((BufferType)((Object)ModObject.blockBuffer.getBlock().func_176203_a((int)stack.func_77960_j()).func_177229_b(BufferType.TYPE))).hasPower) {
            PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return ((BufferType)((Object)ModObject.blockBuffer.getBlock().func_176203_a((int)stack.func_77960_j()).func_177229_b(BufferType.TYPE))).isCreative || super.func_77636_d(stack);
    }

    @Override
    public int getMaxEnergyStored(ItemStack stack) {
        BufferType type = (BufferType)((Object)ModObject.blockBuffer.getBlock().func_176203_a(stack.func_77960_j()).func_177229_b(BufferType.TYPE));
        return type.hasPower ? CapacitorKey.BUFFER_POWER_BUFFER.get(DefaultCapacitorData.BASIC_CAPACITOR) : 0;
    }

    @Override
    public int getMaxInput(ItemStack container) {
        BufferType type = (BufferType)((Object)ModObject.blockBuffer.getBlock().func_176203_a(container.func_77960_j()).func_177229_b(BufferType.TYPE));
        return type.hasPower ? Config.powerConduitTierThreeRF / 20 : 0;
    }

    @Override
    public int getMaxOutput(ItemStack container) {
        return this.getMaxInput(container);
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new InnerProv(stack);
    }

    private class InnerProv
    implements ICapabilityProvider {
        private final ItemStack container;
        private final ItemPowerCapabilityBackend backend;

        public InnerProv(ItemStack container) {
            this.container = container;
            this.backend = new ItemPowerCapabilityBackend(container);
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return this.backend.hasCapability(capability, facing) && ((BufferType)((Object)ModObject.blockBuffer.getBlock().func_176203_a((int)this.container.func_77960_j()).func_177229_b(BufferType.TYPE))).hasPower;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (!this.hasCapability(capability, facing)) {
                return null;
            }
            BufferType type = (BufferType)((Object)ModObject.blockBuffer.getBlock().func_176203_a(this.container.func_77960_j()).func_177229_b(BufferType.TYPE));
            if (!type.hasPower || this.container.field_77994_a > 1) {
                return null;
            }
            if (type.isCreative) {
                return null;
            }
            return this.backend.getCapability(capability, facing);
        }
    }
}

