/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.jei;

import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeWrapper
extends BlankRecipeWrapper {
    private final IRecipe recipe;

    public RecipeWrapper(IRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        List<List<ItemStack>> inputStacks = this.recipe.getInputStackAlternatives();
        if (inputStacks != null) {
            ingredients.setInputLists(ItemStack.class, inputStacks);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (RecipeOutput out : this.recipe.getOutputs()) {
            if (out.getOutput() == null) continue;
            outputs.add(out.getOutput());
        }
        ingredients.setOutputs(ItemStack.class, outputs);
        List<FluidStack> inputFluidStacks = this.recipe.getInputFluidStacks();
        if (inputFluidStacks != null) {
            ingredients.setInputs(FluidStack.class, inputFluidStacks);
        }
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        for (RecipeOutput out : this.recipe.getOutputs()) {
            if (out.getFluidOutput() == null) continue;
            fluidOutputs.add(out.getFluidOutput());
        }
        ingredients.setOutputs(FluidStack.class, fluidOutputs);
    }

    public boolean isValid() {
        return this.recipe != null && this.recipe.isValid();
    }

    public int getEnergyRequired() {
        return this.recipe.getEnergyRequired();
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }
}

