/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.Log;
import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.RecipeRoot;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.Alias;
import crazypants.enderio.config.recipes.xml.Recipe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Recipes
implements RecipeRoot {
    private List<Alias> aliases;
    private List<Recipe> recipes;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.recipes != null || this.aliases != null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void register() {
        Log.debug("Starting registering XML recipes");
        if (this.recipes != null) {
            for (Recipe recipe : this.recipes) {
                recipe.register();
            }
        }
        Log.debug("Done registering XML recipes");
    }

    void initEmpty() {
        this.recipes = new ArrayList<Recipe>();
    }

    @Override
    public void addRecipes(RecipeRoot other) {
        if (other instanceof Recipes) {
            if (((Recipes)other).recipes != null) {
                if (this.recipes != null) {
                    HashSet<String> recipeNames = new HashSet<String>();
                    for (Recipe recipe : this.recipes) {
                        recipeNames.add(recipe.getName());
                    }
                    for (Recipe recipe : ((Recipes)other).recipes) {
                        if (recipeNames.contains(recipe.getName())) continue;
                        this.recipes.add(recipe);
                    }
                } else {
                    this.recipes = ((Recipes)other).recipes;
                }
            }
            if (((Recipes)other).aliases != null) {
                if (this.aliases != null) {
                    HashSet<String> aliasNames = new HashSet<String>();
                    for (Alias alias : this.aliases) {
                        aliasNames.add(alias.getName());
                    }
                    for (Alias alias : ((Recipes)other).aliases) {
                        if (aliasNames.contains(alias.getName())) continue;
                        this.aliases.add(alias);
                    }
                } else {
                    this.aliases = ((Recipes)other).aliases;
                }
            }
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("enderio".equals(name)) {
            return true;
        }
        if ("xsi".equals(name)) {
            return true;
        }
        return "schemaLocation".equals(name);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("alias".equals(name)) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<Alias>();
            }
            this.aliases.add(factory.read(new Alias(), startElement));
            return true;
        }
        if ("recipe".equals(name)) {
            Recipe recipe = factory.read(new Recipe(), startElement);
            if (this.recipes == null) {
                this.recipes = new ArrayList<Recipe>();
            } else {
                for (Recipe existingRecipe : this.recipes) {
                    if (!existingRecipe.getName().equals(recipe.getName())) continue;
                    throw new InvalidRecipeConfigException("Duplicate recipe " + recipe.getName());
                }
            }
            this.recipes.add(recipe);
            return true;
        }
        return false;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (this.recipes != null) {
            for (Recipe recipe : this.recipes) {
                recipe.enforceValidity();
            }
        }
    }

    @Override
    public <T extends RecipeRoot> T copy(T in) {
        if (in instanceof Recipes) {
            Recipes result = new Recipes();
            if (this.aliases != null) {
                result.aliases = new ArrayList<Alias>(this.aliases);
            }
            if (this.recipes != null) {
                result.recipes = new ArrayList<Recipe>(this.recipes);
            }
            return (T)result;
        }
        return null;
    }
}

