/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.ModObject;
import crazypants.enderio.capability.ItemTools;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitComponent;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.ItemSettings;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.FunctionUpgrade;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduit.item.ItemExtractSpeedUpgrade;
import crazypants.enderio.conduit.item.ItemFunctionUpgrade;
import crazypants.enderio.conduit.item.SpeedUpgrade;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.conduit.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.item.PacketConduitProbe;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.invpanel.chest.TileInventoryChest;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemConduit
extends AbstractConduit
implements IItemConduit,
IConduitComponent {
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    public static final String EXTERNAL_INTERFACE_GEOM = "ExternalInterface";
    public static final String ICON_KEY = "enderio:blocks/itemConduit";
    public static final String ICON_KEY_CORE = "enderio:blocks/itemConduitCore";
    public static final String ICON_KEY_INPUT = "enderio:blocks/itemConduitInput";
    public static final String ICON_KEY_OUTPUT = "enderio:blocks/itemConduitOutput";
    public static final String ICON_KEY_IN_OUT_OUT = "enderio:blocks/itemConduitInOut_Out";
    public static final String ICON_KEY_IN_OUT_IN = "enderio:blocks/itemConduitInOut_In";
    public static final String ICON_KEY_IN_OUT_BG = "enderio:blocks/itemConduitIoConnector";
    public static final String ICON_KEY_ENDER = "enderio:blocks/ender_still";
    static final Map<String, TextureAtlasSprite> ICONS = new HashMap<String, TextureAtlasSprite>();
    ItemConduitNetwork network;
    protected final EnumMap<EnumFacing, RedstoneControlMode> extractionModes = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> extractionColors = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, IItemFilter> outputFilters = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, IItemFilter> inputFilters = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> outputFilterUpgrades = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> inputFilterUpgrades = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> speedUpgrades = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> functionUpgrades = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, Boolean> selfFeed = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, Boolean> roundRobin = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, Integer> priority = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> outputColors = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> inputColors = new EnumMap(EnumFacing.class);
    private int metaData;

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(TextureMap register) {
                ICONS.put(ItemConduit.ICON_KEY, register.func_174942_a(new ResourceLocation(ItemConduit.ICON_KEY)));
                ICONS.put(ItemConduit.ICON_KEY_CORE, register.func_174942_a(new ResourceLocation(ItemConduit.ICON_KEY_CORE)));
                ICONS.put(ItemConduit.ICON_KEY_INPUT, register.func_174942_a(new ResourceLocation(ItemConduit.ICON_KEY_INPUT)));
                ICONS.put(ItemConduit.ICON_KEY_OUTPUT, register.func_174942_a(new ResourceLocation(ItemConduit.ICON_KEY_OUTPUT)));
                ICONS.put(ItemConduit.ICON_KEY_IN_OUT_OUT, register.func_174942_a(new ResourceLocation(ItemConduit.ICON_KEY_IN_OUT_OUT)));
                ICONS.put(ItemConduit.ICON_KEY_IN_OUT_IN, register.func_174942_a(new ResourceLocation(ItemConduit.ICON_KEY_IN_OUT_IN)));
                ICONS.put(ItemConduit.ICON_KEY_IN_OUT_BG, register.func_174942_a(new ResourceLocation(ItemConduit.ICON_KEY_IN_OUT_BG)));
                ICONS.put(ItemConduit.ICON_KEY_ENDER, register.func_174942_a(new ResourceLocation(ItemConduit.ICON_KEY_ENDER)));
            }
        });
    }

    public ItemConduit() {
        this(0);
    }

    public ItemConduit(int itemDamage) {
        this.metaData = itemDamage;
    }

    @Override
    protected void readTypeSettings(EnumFacing dir, NBTTagCompound dataRoot) {
        this.setExtractionSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("extractionSignalColor")]);
        this.setExtractionRedstoneMode(RedstoneControlMode.values()[dataRoot.func_74765_d("extractionRedstoneMode")], dir);
        this.setInputColor(dir, DyeColor.values()[dataRoot.func_74765_d("inputColor")]);
        this.setOutputColor(dir, DyeColor.values()[dataRoot.func_74765_d("outputColor")]);
        this.setSelfFeedEnabled(dir, dataRoot.func_74767_n("selfFeed"));
        this.setRoundRobinEnabled(dir, dataRoot.func_74767_n("roundRobin"));
        this.setOutputPriority(dir, dataRoot.func_74762_e("outputPriority"));
    }

    @Override
    protected void writeTypeSettingsToNbt(EnumFacing dir, NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
        dataRoot.func_74777_a("inputColor", (short)this.getInputColor(dir).ordinal());
        dataRoot.func_74777_a("outputColor", (short)this.getOutputColor(dir).ordinal());
        dataRoot.func_74757_a("selfFeed", this.isSelfFeedEnabled(dir));
        dataRoot.func_74757_a("roundRobin", this.isRoundRobinEnabled(dir));
        dataRoot.func_74768_a("outputPriority", this.getOutputPriority(dir));
    }

    protected void convertToItemUpgrades(int filterMeta, Map<EnumFacing, ItemStack> converted, EnumMap<EnumFacing, IItemFilter> sourceFilters) {
        for (Map.Entry<EnumFacing, IItemFilter> entry : sourceFilters.entrySet()) {
            if (entry.getValue() == null) continue;
            IItemFilter f = entry.getValue();
            ItemStack up = new ItemStack(ModObject.itemBasicFilterUpgrade.getItem(), 1, filterMeta);
            FilterRegister.writeFilterToStack(f, up);
            converted.put(entry.getKey(), up);
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        res.add(this.createItem());
        for (ItemStack stack : this.speedUpgrades.values()) {
            res.add(stack);
        }
        for (ItemStack stack : this.functionUpgrades.values()) {
            res.add(stack);
        }
        for (ItemStack stack : this.inputFilterUpgrades.values()) {
            res.add(stack);
        }
        for (ItemStack stack : this.outputFilterUpgrades.values()) {
            res.add(stack);
        }
        return res;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, RaytraceResult res, List<RaytraceResult> all) {
        EnumFacing connDir;
        if (ConduitUtil.isProbeEquipped(player, hand)) {
            if (!player.field_70170_p.field_72995_K) {
                PacketConduitProbe.sendInfoMessage(player, this, null);
            }
            return true;
        }
        if (ToolUtil.isToolEquipped(player, hand)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
                EnumFacing connDir2 = res.component.dir;
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (connDir2 == null || connDir2 == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    return ConduitUtil.joinConduits(this, faceHit);
                }
                if (this.externalConnections.contains(connDir2)) {
                    this.setConnectionMode(connDir2, this.getNextConnectionMode(connDir2));
                    return true;
                }
                if (this.containsConduitConnection(connDir2)) {
                    ConduitUtil.disconectConduits(this, connDir2);
                    return true;
                }
            }
        } else if (res != null && res.component != null && (connDir = res.component.dir) != null && this.containsExternalConnection(connDir)) {
            if (!player.field_70170_p.field_72995_K) {
                PacketConduitProbe.sendInfoMessage(player, this, player.func_184586_b(hand));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setInputFilter(EnumFacing dir, IItemFilter filter) {
        this.inputFilters.put(dir, filter);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilter(EnumFacing dir, IItemFilter filter) {
        this.outputFilters.put(dir, filter);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
    }

    @Override
    public IItemFilter getInputFilter(EnumFacing dir) {
        return this.inputFilters.get(dir);
    }

    @Override
    public IItemFilter getOutputFilter(EnumFacing dir) {
        return this.outputFilters.get(dir);
    }

    @Override
    public void setInputFilterUpgrade(EnumFacing dir, ItemStack stack) {
        this.inputFilterUpgrades.put(dir, stack);
        this.setInputFilter(dir, FilterRegister.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilterUpgrade(EnumFacing dir, ItemStack stack) {
        this.outputFilterUpgrades.put(dir, stack);
        this.setOutputFilter(dir, FilterRegister.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    public ItemStack getInputFilterUpgrade(EnumFacing dir) {
        return this.inputFilterUpgrades.get(dir);
    }

    @Override
    public ItemStack getOutputFilterUpgrade(EnumFacing dir) {
        return this.outputFilterUpgrades.get(dir);
    }

    @Override
    public void setSpeedUpgrade(EnumFacing dir, ItemStack upgrade) {
        if (upgrade != null) {
            this.speedUpgrades.put(dir, upgrade);
        } else {
            this.speedUpgrades.remove(dir);
        }
        this.setClientStateDirty();
    }

    @Override
    public ItemStack getSpeedUpgrade(EnumFacing dir) {
        return this.speedUpgrades.get(dir);
    }

    @Override
    public void setFunctionUpgrade(EnumFacing dir, ItemStack upgrade) {
        boolean hadIPU = this.hasInventoryPanelUpgrade(dir);
        if (upgrade != null) {
            this.functionUpgrades.put(dir, upgrade);
        } else {
            this.functionUpgrades.remove(dir);
        }
        this.setClientStateDirty();
        if (this.network != null && hadIPU != this.hasInventoryPanelUpgrade(dir)) {
            this.network.inventoryPanelSourcesChanged();
        }
    }

    @Override
    public ItemStack getFunctionUpgrade(EnumFacing dir) {
        return this.functionUpgrades.get(dir);
    }

    @Override
    public boolean hasInventoryPanelUpgrade(EnumFacing dir) {
        ItemStack upgrade = this.functionUpgrades.get(dir);
        return upgrade != null && ItemFunctionUpgrade.getFunctionUpgrade(upgrade) == FunctionUpgrade.INVENTORY_PANEL || this.isConnectedToNetworkAwareBlock(dir);
    }

    private boolean isConnectedToNetworkAwareBlock(EnumFacing dir) {
        if (!this.externalConnections.contains(dir)) {
            return false;
        }
        World world = this.getBundle().getBundleWorldObj();
        if (world == null) {
            return false;
        }
        BlockPos loc = this.getLocation().getLocation(dir).getBlockPos();
        if (!world.func_175667_e(loc)) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(loc);
        return tileEntity instanceof TileInventoryChest;
    }

    @Override
    public int getMetaData() {
        return this.metaData;
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, EnumFacing dir) {
        this.extractionModes.put(dir, mode);
    }

    @Override
    public RedstoneControlMode getExtractionRedstoneMode(EnumFacing dir) {
        RedstoneControlMode res = this.extractionModes.get(dir);
        if (res == null) {
            res = RedstoneControlMode.NEVER;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(EnumFacing dir, DyeColor col) {
        this.extractionColors.put(dir, col);
    }

    @Override
    public DyeColor getExtractionSignalColor(EnumFacing dir) {
        DyeColor result = this.extractionColors.get(dir);
        if (result == null) {
            return DyeColor.RED;
        }
        return result;
    }

    @Override
    public boolean isExtractionRedstoneConditionMet(EnumFacing dir) {
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        return ConduitUtil.isRedstoneControlModeMet(this, mode, this.getExtractionSignalColor(dir));
    }

    @Override
    public DyeColor getInputColor(EnumFacing dir) {
        DyeColor result = this.inputColors.get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    @Override
    public DyeColor getOutputColor(EnumFacing dir) {
        DyeColor result = this.outputColors.get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    @Override
    public void setInputColor(EnumFacing dir, DyeColor col) {
        this.inputColors.put(dir, col);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public void setOutputColor(EnumFacing dir, DyeColor col) {
        this.outputColors.put(dir, col);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public int getMaximumExtracted(EnumFacing dir) {
        ItemStack stack = this.speedUpgrades.get(dir);
        if (stack == null) {
            return 4;
        }
        SpeedUpgrade speedUpgrade = ItemExtractSpeedUpgrade.getSpeedUpgrade(stack);
        return speedUpgrade.getMaximumExtracted(stack.field_77994_a);
    }

    @Override
    public float getTickTimePerItem(EnumFacing dir) {
        float maxExtract = 10.0f / (float)this.getMaximumExtracted(dir);
        return maxExtract;
    }

    @Override
    public void itemsExtracted(int numExtracted, int slot) {
    }

    @Override
    public void externalConnectionAdded(EnumFacing direction) {
        super.externalConnectionAdded(direction);
        if (this.network != null) {
            TileEntity te = this.bundle.getEntity();
            BlockPos p = te.func_174877_v().func_177972_a(direction);
            this.network.inventoryAdded(this, direction, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), this.getExternalInventory(direction));
        }
    }

    @Override
    public IItemHandler getExternalInventory(EnumFacing direction) {
        World world = this.getBundle().getBundleWorldObj();
        if (world == null) {
            return null;
        }
        BlockCoord loc = this.getLocation().getLocation(direction);
        return ItemTools.getExternalInventory((IBlockAccess)world, loc.getBlockPos(), direction.func_176734_d());
    }

    @Override
    public void externalConnectionRemoved(EnumFacing direction) {
        this.externalConnections.remove(direction);
        this.connectionsChanged();
        if (this.network != null) {
            TileEntity te = this.bundle.getEntity();
            BlockPos p = te.func_174877_v().func_177972_a(direction);
            this.network.inventoryRemoved(this, p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
        }
    }

    @Override
    public void setConnectionMode(EnumFacing dir, ConnectionMode mode) {
        ConnectionMode oldVal = (ConnectionMode)((Object)this.conectionModes.get(dir));
        if (oldVal == mode) {
            return;
        }
        super.setConnectionMode(dir, mode);
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean isSelfFeedEnabled(EnumFacing dir) {
        Boolean val = this.selfFeed.get(dir);
        if (val == null) {
            return false;
        }
        return val;
    }

    @Override
    public void setSelfFeedEnabled(EnumFacing dir, boolean enabled) {
        if (!enabled) {
            this.selfFeed.remove(dir);
        } else {
            this.selfFeed.put(dir, enabled);
        }
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean isRoundRobinEnabled(EnumFacing dir) {
        Boolean val = this.roundRobin.get(dir);
        if (val == null) {
            return false;
        }
        return val;
    }

    @Override
    public void setRoundRobinEnabled(EnumFacing dir, boolean enabled) {
        if (!enabled) {
            this.roundRobin.remove(dir);
        } else {
            this.roundRobin.put(dir, enabled);
        }
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public int getOutputPriority(EnumFacing dir) {
        Integer res = this.priority.get(dir);
        if (res == null) {
            return 0;
        }
        return res;
    }

    @Override
    public void setOutputPriority(EnumFacing dir, int priority) {
        if (priority == 0) {
            this.priority.remove(dir);
        } else {
            this.priority.put(dir, priority);
        }
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean canConnectToExternal(EnumFacing direction, boolean ignoreDisabled) {
        return this.getExternalInventory(direction) != null;
    }

    @Override
    protected ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.INPUT;
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IItemConduit.class;
    }

    @Override
    public ItemStack createItem() {
        ItemStack result = new ItemStack(ModObject.itemItemConduit.getItem(), 1, this.metaData);
        return result;
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        this.network = (ItemConduitNetwork)network;
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInputMode() {
        return ICONS.get(ICON_KEY_INPUT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForOutputMode() {
        return ICONS.get(ICON_KEY_OUTPUT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutMode(boolean input) {
        return input ? ICONS.get(ICON_KEY_IN_OUT_IN) : ICONS.get(ICON_KEY_IN_OUT_OUT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutBackground() {
        return ICONS.get(ICON_KEY_IN_OUT_BG);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getEnderIcon() {
        return ICONS.get(ICON_KEY_ENDER);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getCoreIcon() {
        return ICONS.get(ICON_KEY_CORE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForState(CollidableComponent component) {
        if (component.dir == null) {
            return this.getCoreIcon();
        }
        if (EXTERNAL_INTERFACE_GEOM.equals(component.data)) {
            return this.getCoreIcon();
        }
        return ICONS.get(ICON_KEY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTransmitionTextureForState(CollidableComponent component) {
        return this.getEnderIcon();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(CollidableComponent component) {
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        IItemFilter filter;
        NBTTagCompound itemRoot2;
        ItemStack up;
        IItemFilter f;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(f = entry.getValue())) continue;
            NBTTagCompound itemRoot22 = new NBTTagCompound();
            FilterRegister.writeFilterToNbt(f, itemRoot22);
            nbtRoot.func_74782_a("inFilts." + entry.getKey().name(), (NBTBase)itemRoot22);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.speedUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            itemRoot2 = new NBTTagCompound();
            up.func_77955_b(itemRoot2);
            nbtRoot.func_74782_a("speedUpgrades." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.functionUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            itemRoot2 = new NBTTagCompound();
            up.func_77955_b(itemRoot2);
            nbtRoot.func_74782_a("functionUpgrades." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(f = entry.getValue())) continue;
            itemRoot2 = new NBTTagCompound();
            FilterRegister.writeFilterToNbt(f, itemRoot2);
            nbtRoot.func_74782_a("outFilts." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.inputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            filter = this.getInputFilter(entry.getKey());
            FilterRegister.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("inputFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.outputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            filter = this.getOutputFilter(entry.getKey());
            FilterRegister.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("outputFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.extractionModes.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((RedstoneControlMode)((Object)entry.getValue())).ordinal();
            nbtRoot.func_74777_a("extRM." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.extractionColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("extSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.selfFeed.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("selfFeed." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.roundRobin.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("roundRobin." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.priority.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74768_a("priority." + entry.getKey().name(), ((Integer)entry.getValue()).intValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.inputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("inSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.outputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("outSC." + entry.getKey().name(), ord);
        }
    }

    private boolean isDefault(IItemFilter f) {
        if (f instanceof ItemFilter) {
            return ((ItemFilter)f).isDefault();
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.metaData = nbtRoot.func_74764_b("metaData") ? (int)nbtRoot.func_74765_d("metaData") : 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            ItemStack ups;
            NBTTagCompound upTag;
            IItemFilter filter;
            NBTTagCompound filterTag;
            String key = "inFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = FilterRegister.loadFilterFromNbt(filterTag);
                this.inputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "speedUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = ItemStack.func_77949_a((NBTTagCompound)upTag);
                this.speedUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "functionUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = ItemStack.func_77949_a((NBTTagCompound)upTag);
                this.functionUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "inputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = ItemStack.func_77949_a((NBTTagCompound)upTag);
                this.inputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = ItemStack.func_77949_a((NBTTagCompound)upTag);
                this.outputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outFilts." + dir.name())) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = FilterRegister.loadFilterFromNbt(filterTag);
                this.outputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "extRM." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.extractionModes.put(dir, RedstoneControlMode.values()[ord]);
            }
            if (nbtRoot.func_74764_b(key = "extSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.extractionColors.put(dir, DyeColor.values()[ord]);
            }
            if (nbtRoot.func_74764_b(key = "selfFeed." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.selfFeed.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "roundRobin." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.roundRobin.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "priority." + dir.name())) {
                int val = nbtRoot.func_74762_e(key);
                this.priority.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "inSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.inputColors.put(dir, DyeColor.values()[ord]);
            }
            if (!nbtRoot.func_74764_b(key = "outSC." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.outputColors.put(dir, DyeColor.values()[ord]);
        }
        if (nbtVersion == 0 && !nbtRoot.func_74764_b("conModes")) {
            for (EnumFacing dir : this.externalConnections) {
                this.conectionModes.put(dir, ConnectionMode.OUTPUT);
            }
        }
        this.connectionsDirty = true;
    }

    @Override
    public boolean onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbourPos) {
        if (neighbourPos != null && this.network != null && this.network.hasDatabase()) {
            this.network.getDatabase().onNeighborChange(neighbourPos);
        }
        return super.onNeighborChange(world, pos, neighbourPos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(IBlockStateWrapper wrapper, BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(wrapper, hashCodes);
        hashCodes.addEnum(this.outputColors);
        hashCodes.addEnum(this.inputColors);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.network != null) {
            BlockPos pos = this.bundle.getEntity().func_174877_v();
            for (EnumFacing direction : this.externalConnections) {
                try {
                    BlockPos p = pos.func_177972_a(direction);
                    this.network.inventoryRemoved(this, p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public ItemConduitNetwork createNetworkForType() {
        return new ItemConduitNetwork();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ITabPanel createPanelForConduit(GuiExternalConnection gui, IConduit con) {
        return new ItemSettings(gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getTabOrderForConduit(IConduit con) {
        return 0;
    }
}

