/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.utils;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.common.utils.WorldUtil;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.net.pkt.PacketSetBiome;
import com.mrdimka.hammercore.tile.TileSyncable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class WorldLocation {
    private transient World world;
    private transient BlockPos pos;

    public WorldLocation(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public AxisAlignedBB getAABB() {
        return new AxisAlignedBB(this.pos);
    }

    public TileEntity getTile() {
        return this.world.func_175667_e(this.pos) ? this.world.func_175625_s(this.pos) : null;
    }

    public <T extends TileEntity> T getTileOfType(Class<T> tile) {
        return (T)((TileEntity)WorldUtil.cast(this.getTile(), tile));
    }

    public boolean isLoaded() {
        return this.world.func_175667_e(this.pos);
    }

    public void setTile(TileEntity tile) {
        if (this.isLoaded()) {
            this.world.func_175690_a(this.pos, tile);
        }
    }

    public IBlockState getState() {
        return this.isLoaded() ? this.world.func_180495_p(this.pos) : Blocks.field_150350_a.func_176223_P();
    }

    public Block getBlock() {
        return this.getState().func_177230_c();
    }

    public int getMeta() {
        return this.getBlock().func_176201_c(this.getState());
    }

    public void setState(IBlockState state) {
        if (this.isLoaded()) {
            this.world.func_175656_a(this.pos, state);
        }
    }

    public void setState(IBlockState state, int flags) {
        if (this.isLoaded()) {
            this.world.func_180501_a(this.pos, state, flags);
        }
    }

    public void setAir() {
        if (this.isLoaded()) {
            this.world.func_175698_g(this.pos);
        }
    }

    public void destroyBlock(boolean dropBlock) {
        if (this.isLoaded()) {
            this.world.func_175655_b(this.pos, dropBlock);
        }
    }

    public boolean canSeeSky() {
        return this.canSeeSky(false);
    }

    public boolean canSeeSky(boolean __default) {
        if (this.isLoaded()) {
            return this.world.func_175678_i(this.pos);
        }
        return __default;
    }

    public int getLight() {
        if (this.isLoaded()) {
            return this.world.func_175699_k(this.pos);
        }
        return 0;
    }

    public int getLightFor(EnumSkyBlock type) {
        if (this.isLoaded()) {
            return this.world.func_175642_b(type, this.pos);
        }
        return 0;
    }

    public BlockPos getHeight() {
        return this.world.func_175645_m(this.pos);
    }

    public void setLight(EnumSkyBlock type, int lightValue) {
        this.world.func_175653_a(type, this.pos, lightValue);
    }

    public Biome getBiome() {
        return this.isLoaded() ? this.world.func_180494_b(this.pos) : Biomes.field_76772_c;
    }

    public void setBiome(Biome biome) {
        if (this.isLoaded()) {
            int i = this.pos.func_177958_n() & 0xF;
            int j = this.pos.func_177952_p() & 0xF;
            int id = j << 4 | i;
            byte[] blockBiomeArray = this.world.func_175726_f(this.pos).func_76605_m();
            blockBiomeArray[id] = (byte)(Biome.func_185362_a((Biome)biome) & 0xFF);
            if (!this.world.field_72995_K) {
                HCNetwork.manager.sendToAllAround(new PacketSetBiome(i, j, id, blockBiomeArray[id]), this.getPointWithRad(296));
            }
        }
    }

    public NetworkRegistry.TargetPoint getPointWithRad(int radius) {
        return new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, (double)radius);
    }

    public void setMeta(int meta) {
        if (this.isLoaded()) {
            this.world.func_175656_a(this.pos, this.getBlock().func_176203_a(meta));
        }
    }

    public void setBlock(Block block) {
        if (this.isLoaded()) {
            this.world.func_175656_a(this.pos, block.func_176203_a(this.getMeta()));
        }
    }

    public WorldLocation offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    public WorldLocation offset(EnumFacing facing, int steps) {
        return new WorldLocation(this.world, this.pos.func_177967_a(facing, steps));
    }

    public WorldLocation offset(int x, int y, int z) {
        return new WorldLocation(this.world, this.pos.func_177982_a(x, y, z));
    }

    protected void finalize() throws Throwable {
        this.world = null;
        this.pos = null;
        super.finalize();
    }

    public Material getMaterial() {
        return this.getBlock().func_149688_o(this.getState());
    }

    public SoundType getSoundType() {
        return this.getSoundType(null);
    }

    public SoundType getSoundType(Entity e) {
        return this.getBlock().getSoundType(this.getState(), this.getWorld(), this.getPos(), e);
    }

    public int getRedstone() {
        return this.isLoaded() ? this.world.func_175687_A(this.pos) : 0;
    }

    public void markDirty() {
        this.markDirty(3);
    }

    public Chunk getChunk() {
        return this.world.func_175726_f(this.pos);
    }

    public void markDirty(int flags) {
        if (this.world.field_72995_K) {
            return;
        }
        this.world.markAndNotifyBlock(this.pos, this.world.func_175726_f(this.pos), this.getState(), this.getState(), flags);
        TileSyncable sync = this.getTileOfType(TileSyncable.class);
        if (sync != null) {
            sync.sync();
        }
    }

    public void playSound(String sound, float volume, float pitch, SoundCategory cat) {
        HammerCore.audioProxy.playSoundAt(this.world, sound, this.pos, volume, pitch, cat);
    }
}

