/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.utils;

import com.mrdimka.hammercore.common.utils.ArrayEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexedMap<K, V>
implements Map<K, V>,
Serializable {
    private final List<K> keys = new ArrayList<K>();
    private final List<V> values = new ArrayList<V>();

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public V get(Object key) {
        if (this.containsKey(key)) {
            return this.values.get(this.keys.indexOf(key));
        }
        return null;
    }

    public K getKey(V value) {
        if (this.containsValue(value)) {
            return this.keys.get(this.values.indexOf(value));
        }
        return null;
    }

    public K getKey(int index) {
        if (index < 0 || index >= this.keys.size()) {
            return null;
        }
        return this.keys.get(index);
    }

    public V getValue(int index) {
        if (index < 0 || index >= this.values.size()) {
            return null;
        }
        return this.values.get(index);
    }

    public int indexOf(K key) {
        return this.keys.indexOf(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.containsKey(key)) {
            int i = this.keys.indexOf(key);
            V pval = this.values.get(i);
            this.keys.set(i, key);
            this.values.set(i, value);
            return pval;
        }
        this.keys.add(key);
        this.values.add(value);
        return null;
    }

    @Override
    public V remove(Object key) {
        if (this.containsKey(key)) {
            int i = this.keys.indexOf(key);
            this.keys.remove(i);
            return this.values.remove(i);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public Set<K> keySet() {
        return new LinkedHashSet<K>(this.keys);
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> set = new LinkedHashSet<Map.Entry<K, V>>();
        for (K key : this.keys) {
            set.add(new ArrayEntry<K, V>(key, this.values.get(this.keys.indexOf(key))));
        }
        return set;
    }

    public List<K> getKeys() {
        return this.keys;
    }

    public List<V> getValues() {
        return this.values;
    }
}

