/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.client.texture;

import com.google.common.collect.Maps;
import com.pengu.hammercore.client.texture.TextureSpriteCustom;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public enum TextureFXManager {
    INSTANCE;

    private Map<String, TextureAtlasSprite> iconMap = Maps.newHashMap();

    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerIcon(String path, TextureAtlasSprite sprite) {
        if (!this.iconMap.containsKey(path)) {
            this.iconMap.put(path, sprite);
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        for (TextureAtlasSprite s : this.iconMap.values()) {
            if (!(s instanceof TextureSpriteCustom)) continue;
            ((TextureSpriteCustom)s).resetFX(event instanceof TextureStitchEvent.Pre ? 0 : (event instanceof TextureStitchEvent.Post ? 1 : 2));
        }
        event.getMap().field_94252_e.putAll(this.iconMap);
    }
}

