/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.client.render.tesr;

import com.mrdimka.hammercore.client.utils.RenderBlocks;
import com.mrdimka.hammercore.tile.TileSyncable;
import com.pengu.hammercore.client.DestroyStageTexture;
import com.pengu.hammercore.client.render.item.IItemRender;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public abstract class TESR<T extends TileEntity>
extends TileEntitySpecialRenderer<T>
implements IItemRender {
    protected float destroyProgress;
    protected Minecraft mc = Minecraft.func_71410_x();

    public final void func_180535_a(T te, double x, double y, double z, float partialTicks, int destroyStage) {
        try {
            float progress;
            ResourceLocation destroy = null;
            RayTraceResult over = this.mc.field_71476_x;
            this.destroyProgress = 0.0f;
            if (over != null && over.field_72313_a == RayTraceResult.Type.BLOCK && over.func_178782_a().equals((Object)te.func_174877_v()) && (progress = (this.destroyProgress = Minecraft.func_71410_x().field_71442_b.field_78770_f)) > 0.0f) {
                destroy = DestroyStageTexture.getByProgress(progress);
            }
            this.renderTileEntityAt(te, x, y, z, partialTicks, destroy);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void renderTileEntityFast(T te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
        float progress;
        ResourceLocation destroy = null;
        RayTraceResult over = this.mc.field_71476_x;
        if (over != null && over.field_72313_a == RayTraceResult.Type.BLOCK && over.func_178782_a().equals((Object)te.func_174877_v()) && (progress = Minecraft.func_71410_x().field_71442_b.field_78770_f) > 0.0f) {
            destroy = DestroyStageTexture.getByProgress(progress);
        }
        this.renderTileEntityFast(te, x, y, z, partialTicks, destroy, buffer);
    }

    public boolean canRenderFromNbt() {
        return false;
    }

    public void renderFromNBT(@Nonnull NBTTagCompound nbt, double x, double y, double z, float partialTicks, @Nullable ResourceLocation destroyStage) {
    }

    public void renderFromNBTFast(@Nonnull NBTTagCompound nbt, double x, double y, double z, float partialTicks, @Nullable ResourceLocation destroyStage, VertexBuffer buffer) {
    }

    public void renderTileEntityAt(@Nonnull T te, double x, double y, double z, float partialTicks, @Nullable ResourceLocation destroyStage) {
        if (this.canRenderFromNbt()) {
            this.renderFromNBT(TESR.getNBTFromTile(te), x, y, z, partialTicks, destroyStage);
        }
    }

    public void renderTileEntityFast(@Nonnull T te, double x, double y, double z, float partialTicks, @Nullable ResourceLocation destroyStage, VertexBuffer buffer) {
        if (this.canRenderFromNbt()) {
            this.renderFromNBTFast(TESR.getNBTFromTile(te), x, y, z, partialTicks, destroyStage, buffer);
        }
    }

    @Override
    public void renderItem(ItemStack item) {
        NBTTagCompound nbt;
        if (this.canRenderFromNbt() && (nbt = TESR.getNBTFromItemStack(item)) != null) {
            this.renderFromNBT(nbt, 0.0, 0.0, 0.0, 0.0f, null);
        }
    }

    public static NBTTagCompound getNBTFromTile(TileEntity tile) {
        if (tile instanceof TileSyncable) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((TileSyncable)tile).writeNBT(nbt);
            return nbt;
        }
        return tile.serializeNBT();
    }

    @Nullable
    public static NBTTagCompound getNBTFromItemStack(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags = tags.func_74775_l("BlockEntityTag");
        }
        if (tags != null && !tags.func_82582_d()) {
            return tags.func_74775_l("tags");
        }
        return null;
    }

    protected int getBrightnessForRB(T te, RenderBlocks rb) {
        return te != null ? rb.setLighting(te.func_145831_w(), te.func_174877_v()) : rb.setLighting((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_180425_c());
    }
}

