/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.asm;

import com.pengu.hammercore.asm.HammerCoreCore;
import com.pengu.hammercore.asm.ObjectWebUtils;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class HammerCoreTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        return this.handleTransform(name, transformedName, basicClass);
    }

    private byte[] handleTransform(String name, String transformedName, byte[] basicClass) {
        String CL_OBF = "rb";
        String CL_DEOBF = "net.minecraft.util.HttpUtil";
        String FN_OBF = "a";
        String FN_DEOBF = "getSuitableLanPort";
        if (name.equals(CL_OBF) || name.equals(CL_DEOBF) || transformedName.equals(CL_DEOBF)) {
            boolean obf = name.equals(CL_OBF);
            HammerCoreCore.ASM_LOG.info("Transforming net.minecraft.util.HttpUtil (" + name + ")...", new Object[0]);
            ClassNode classNode = ObjectWebUtils.loadClass(basicClass);
            String targetMethod = obf ? FN_OBF : FN_DEOBF;
            for (MethodNode m : classNode.methods) {
                if (!m.name.equals(targetMethod) || !m.desc.equals("()I")) continue;
                int index = -1;
                AbstractInsnNode instruction = null;
                ListIterator instructions = m.instructions.iterator();
                while (instructions.hasNext()) {
                    ++index;
                    instruction = (AbstractInsnNode)instructions.next();
                    if (instruction.getOpcode() != 3) continue;
                    AbstractInsnNode toRemove = m.instructions.get(index);
                    m.instructions.remove(toRemove);
                    InsnList toInject = new InsnList();
                    toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/pengu/hammercore/net/LanUtil", "getSuitableLanPort", "()I"));
                    m.instructions.insertBefore(m.instructions.get(index), toInject);
                    HammerCoreCore.ASM_LOG.info("-Sending instructions to HttpUtil for function getSuitableLanPort", new Object[0]);
                }
            }
            return ObjectWebUtils.writeClassToByteArray(classNode);
        }
        return basicClass;
    }
}

