/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.raytracer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.math.MathHelper;
import com.mrdimka.hammercore.raytracer.ExtendedRayTraceResult;
import com.mrdimka.hammercore.raytracer.IndexedCuboid6;
import com.mrdimka.hammercore.vec.Cuboid6;
import com.mrdimka.hammercore.vec.Vector3;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RayTracer {
    private Vector3 vec = new Vector3();
    private Vector3 vec2 = new Vector3();
    private Vector3 s_vec = new Vector3();
    private double s_dist;
    private int s_side;
    private IndexedCuboid6 c_cuboid;
    private static ThreadLocal<RayTracer> t_inst = new ThreadLocal();

    public static RayTracer instance() {
        RayTracer inst = t_inst.get();
        if (inst == null) {
            inst = new RayTracer();
            t_inst.set(inst);
        }
        return inst;
    }

    private void traceSide(int side, Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.vec.set(start);
        Vector3 hit = null;
        switch (side) {
            case 0: {
                hit = this.vec.XZintercept(end, cuboid.min.y);
                break;
            }
            case 1: {
                hit = this.vec.XZintercept(end, cuboid.max.y);
                break;
            }
            case 2: {
                hit = this.vec.XYintercept(end, cuboid.min.z);
                break;
            }
            case 3: {
                hit = this.vec.XYintercept(end, cuboid.max.z);
                break;
            }
            case 4: {
                hit = this.vec.YZintercept(end, cuboid.min.x);
                break;
            }
            case 5: {
                hit = this.vec.YZintercept(end, cuboid.max.x);
            }
        }
        if (hit == null) {
            return;
        }
        switch (side) {
            case 0: 
            case 1: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
            case 2: 
            case 3: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y)) break;
                return;
            }
            case 4: 
            case 5: {
                if (MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
        }
        double dist = this.vec2.set(hit).subtract(start).magSquared();
        if (dist < this.s_dist) {
            this.s_side = side;
            this.s_dist = dist;
            this.s_vec.set(this.vec);
        }
    }

    public boolean rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.s_dist = Double.MAX_VALUE;
        this.s_side = -1;
        for (int i = 0; i < 6; ++i) {
            this.traceSide(i, start, end, cuboid);
        }
        return this.s_side >= 0;
    }

    public IndexedCuboid6 rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids) {
        double c_dist = Double.MAX_VALUE;
        int c_side = 0;
        Vector3 c_vec = Vector3.zero;
        IndexedCuboid6 c_hit = null;
        for (IndexedCuboid6 cuboid : cuboids) {
            if (!this.rayTraceCuboid(start, end, cuboid) || !(this.s_dist < c_dist)) continue;
            c_dist = this.s_dist;
            c_side = this.s_side;
            c_vec = this.s_vec;
            c_hit = cuboid;
        }
        if (c_hit != null) {
            this.s_dist = c_dist;
            this.s_side = c_side;
            this.s_vec = c_vec;
        }
        return c_hit;
    }

    public ExtendedRayTraceResult rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, BlockPos pos, Object data) {
        return this.rayTraceCuboid(start, end, cuboid) && this.s_side != -1 ? new ExtendedRayTraceResult(this.s_vec, this.s_side, pos, data, this.s_dist) : null;
    }

    public ExtendedRayTraceResult rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, Entity entity, Object data) {
        return this.rayTraceCuboid(start, end, cuboid) ? new ExtendedRayTraceResult(entity, this.s_vec, data, this.s_dist) : null;
    }

    public ExtendedRayTraceResult rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, BlockPos pos) {
        IndexedCuboid6 hit = this.rayTraceCuboids(start, end, cuboids);
        return hit != null && this.s_side != -1 ? new ExtendedRayTraceResult(this.s_vec, this.s_side, pos, hit.data, this.s_dist) : null;
    }

    public ExtendedRayTraceResult rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, Entity entity) {
        IndexedCuboid6 hit = this.rayTraceCuboids(start, end, cuboids);
        return hit != null ? new ExtendedRayTraceResult(entity, this.s_vec, hit.data, this.s_dist) : null;
    }

    public static RayTraceResult retraceBlock(World world, EntityPlayer player, BlockPos pos) {
        IBlockState b = world.func_180495_p(pos);
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return b.func_177230_c().func_180636_a(world.func_180495_p(pos), world, pos, headVec, endVec);
    }

    private static double getBlockReachDistance_server(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return HammerCore.renderProxy.getBlockReachDistance_client();
    }

    public static RayTraceResult retraceFully(EntityPlayer player) {
        return RayTracer.retraceFully(player, RayTracer.getBlockReachDistance(player));
    }

    public static RayTraceResult retrace(EntityPlayer player) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player));
    }

    public static RayTraceResult retrace_stopOnLiquid(EntityPlayer player) {
        return RayTracer.retrace_stopOnLiquid(player, RayTracer.getBlockReachDistance(player));
    }

    public static Entity retraceEntity(EntityPlayer player) {
        return RayTracer.retraceEntity(player, RayTracer.getBlockReachDistance(player));
    }

    public static RayTraceResult retraceFully(EntityPlayer player, double reach) {
        Entity entity = RayTracer.retraceEntity(player, reach);
        RayTraceResult block = RayTracer.retrace(player, reach);
        if (entity != null && (block == null || (double)entity.func_70032_d((Entity)player) <= player.func_174818_b(block.func_178782_a()))) {
            return new RayTraceResult(entity);
        }
        return block;
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return player.field_70170_p.func_147447_a(headVec, endVec, false, true, true);
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach, boolean entities) {
        Entity entityResult;
        if (entities && (entityResult = RayTracer.retraceEntity(player, reach)) != null) {
            return new RayTraceResult(entityResult);
        }
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return player.field_70170_p.func_147447_a(headVec, endVec, false, true, true);
    }

    public static RayTraceResult retrace_stopOnLiquid(EntityPlayer player, double reach) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return player.field_70170_p.func_147447_a(headVec, endVec, true, true, true);
    }

    public static Entity retraceEntity(EntityPlayer player, double reach) {
        Vec3d vec3d = RayTracer.getCorrectedHeadVec(player);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * reach, vec3d1.field_72448_b * reach, vec3d1.field_72449_c * reach);
        Vec3d vec3d3 = null;
        float f = 1.0f;
        List list = player.field_70170_p.func_175674_a((Entity)player, player.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * reach, vec3d1.field_72448_b * reach, vec3d1.field_72449_c * reach).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                return entity != null && entity.func_70067_L();
            }
        }));
        double d2 = reach;
        Entity pointedEntity = null;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == player.func_184208_bv() && !player.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                continue;
            }
            pointedEntity = entity1;
            vec3d3 = raytraceresult.field_72307_f;
            d2 = d3;
        }
        return pointedEntity;
    }

    public static Vec3d getCorrectedHeadVec(EntityPlayer player) {
        Vector3 v = Vector3.fromEntity((Entity)player);
        v.y += (double)player.func_70047_e();
        return v.vec3();
    }

    public static Vec3d getStartVec(EntityPlayer player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    public static double getBlockReachDistance(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? RayTracer.getBlockReachDistance_client() : (player instanceof EntityPlayerMP ? RayTracer.getBlockReachDistance_server((EntityPlayerMP)player) : 5.0);
    }

    public static Vec3d getEndVec(EntityPlayer player) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }
}

