/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.energy;

import com.mrdimka.hammercore.energy.IPowerStorage;
import net.minecraft.nbt.NBTTagCompound;

public class PowerStorage
implements IPowerStorage {
    public int energy;
    public int capacity;
    public int maxReceive;
    public int maxExtract;

    public PowerStorage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public PowerStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public PowerStorage(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public PowerStorage readFromNBT(NBTTagCompound nbt) {
        this.energy = Math.min(nbt.func_74762_e("Energy"), this.capacity);
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Energy", Math.max(this.energy, 0));
        return nbt;
    }

    public PowerStorage setCapacity(int capacity) {
        this.capacity = capacity;
        this.energy = Math.min(this.energy, capacity);
        return this;
    }

    public PowerStorage setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public PowerStorage setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public PowerStorage setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergyStored(int energy) {
        this.energy = Math.max(Math.min(energy, this.capacity), 0);
    }

    public void modifyEnergyStored(int energy) {
        this.energy = Math.max(Math.min(this.energy + energy, this.capacity), 0);
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity;
    }
}

