/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.utils;

import com.mrdimka.hammercore.json.JSONArray;
import com.mrdimka.hammercore.json.JSONException;
import com.mrdimka.hammercore.json.JSONObject;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class JSONObjectToNBT {
    public static NBTTagCompound convert(JSONObject obj) throws JSONException {
        NBTTagCompound nbt = new NBTTagCompound();
        for (String k : obj.keySet()) {
            nbt.func_74782_a(k, JSONObjectToNBT.convertToBase(obj.get(k)));
        }
        return nbt;
    }

    public static NBTTagList convert(JSONArray array) throws JSONException {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < array.length(); ++i) {
            list.func_74742_a(JSONObjectToNBT.convertToBase(array.get(i)));
        }
        return list;
    }

    public static NBTBase convertToBase(Object obj) throws JSONException {
        if (obj instanceof JSONObject) {
            return JSONObjectToNBT.convert((JSONObject)obj);
        }
        if (obj instanceof JSONArray) {
            return JSONObjectToNBT.convert((JSONArray)obj);
        }
        NBTTagByte base = null;
        if (obj instanceof Byte) {
            base = new NBTTagByte(((Byte)obj).byteValue());
        }
        if (obj instanceof byte[]) {
            base = new NBTTagByteArray((byte[])obj);
        }
        if (obj instanceof Double) {
            base = new NBTTagDouble(((Double)obj).doubleValue());
        }
        if (obj instanceof Float) {
            base = new NBTTagFloat(((Float)obj).floatValue());
        }
        if (obj instanceof Integer) {
            base = new NBTTagInt(((Integer)obj).intValue());
        }
        if (obj instanceof int[]) {
            base = new NBTTagIntArray((int[])obj);
        }
        if (obj instanceof Long) {
            base = new NBTTagLong(((Long)obj).longValue());
        }
        if (obj instanceof Short) {
            base = new NBTTagShort(((Short)obj).shortValue());
        }
        if (obj instanceof String) {
            base = new NBTTagString((String)obj);
        }
        return base;
    }
}

