/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.items;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.common.capabilities.CapabilityEJ;
import com.mrdimka.hammercore.common.items.ItemFEBase;
import com.mrdimka.hammercore.common.utils.ChatUtil;
import com.mrdimka.hammercore.energy.IPowerContainerItem;
import com.mrdimka.hammercore.energy.IPowerStorage;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemBattery
extends ItemFEBase {
    public ItemBattery(int capacity, int maxIO) {
        super(capacity);
        this.maxExtract = maxIO;
        this.maxReceive = maxIO;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            ItemStack stack = playerIn.func_184586_b(hand);
            this.setMode(stack, this.getMode(stack).cycle());
            HammerCore.audioProxy.playSoundAt(worldIn, "entity.experience_orb.pickup", playerIn.func_180425_c(), 1.0f, 2.0f, SoundCategory.PLAYERS);
            ChatUtil.sendNoSpam(playerIn, I18n.func_74838_a((String)"info.hammercore:changed_mode") + ": " + (Object)((Object)this.getMode(stack)));
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        block7: {
            EnumBatteryShareMode mode;
            block6: {
                mode = this.getMode(stack);
                if (!mode.isChargingEntireInventory() || !(entityIn instanceof EntityPlayer)) break block6;
                InventoryPlayer inv = ((EntityPlayer)entityIn).field_71071_by;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack a = inv.func_70301_a(i);
                    this.chargeItem(stack, a);
                }
                break block7;
            }
            if (mode.isChargingArmor()) {
                Iterable armorStacks = entityIn.func_184193_aE();
                for (ItemStack a : armorStacks) {
                    this.chargeItem(stack, a);
                }
            }
            if (!mode.isChargingHotbar()) break block7;
            ArrayList<ItemStack> heldEquipmentStacks = entityIn.func_184214_aD();
            if (entityIn instanceof EntityPlayer) {
                ArrayList<ItemStack> stacks;
                InventoryPlayer inv = ((EntityPlayer)entityIn).field_71071_by;
                heldEquipmentStacks = stacks = new ArrayList<ItemStack>();
                for (int i = 0; i < 9; ++i) {
                    stacks.add(inv.func_70301_a(i));
                }
            }
            for (ItemStack a : heldEquipmentStacks) {
                this.chargeItem(stack, a);
            }
        }
    }

    protected void chargeItem(ItemStack batteryStack, ItemStack targetStack) {
        if (targetStack == null) {
            return;
        }
        if (targetStack.func_77973_b() instanceof ItemBattery && this.getMode(targetStack) != EnumBatteryShareMode.NOT_SHARE) {
            return;
        }
        if (targetStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)targetStack.getCapability(CapabilityEnergy.ENERGY, null);
            if (storage != null && storage.canReceive()) {
                this.extractEnergy(batteryStack, storage.receiveEnergy(Math.min(this.getEnergyStored(batteryStack), this.maxExtract), false), false);
            }
        } else if (targetStack.hasCapability(CapabilityEJ.ENERGY, null)) {
            IPowerStorage storage = (IPowerStorage)targetStack.getCapability(CapabilityEJ.ENERGY, null);
            if (storage != null) {
                this.extractEnergy(batteryStack, storage.receiveEnergy(Math.min(this.getEnergyStored(batteryStack), this.maxExtract), false), false);
            }
        } else if (targetStack.func_77973_b() instanceof IPowerContainerItem) {
            IPowerContainerItem pci = (IPowerContainerItem)targetStack.func_77973_b();
            this.extractEnergy(batteryStack, pci.receiveEnergy(targetStack, Math.min(this.getEnergyStored(batteryStack), this.maxExtract), false), false);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getMode(stack) != EnumBatteryShareMode.NOT_SHARE;
    }

    public EnumBatteryShareMode getMode(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return EnumBatteryShareMode.NOT_SHARE;
        }
        return EnumBatteryShareMode.values()[stack.func_77978_p().func_74771_c("ShareMode") % EnumBatteryShareMode.values().length];
    }

    public void setMode(ItemStack stack, EnumBatteryShareMode mode) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74774_a("ShareMode", (byte)(mode != null ? mode.ordinal() : 1));
    }

    public static enum EnumBatteryShareMode {
        NOT_SHARE("noshare"),
        HOTBAR("hotbar"),
        ARMOR("armor"),
        ARMOR_AND_HOTBAR("armor_hotbar"),
        ENTIRE_INVENTORY("inventory");

        private final String i18n;

        private EnumBatteryShareMode(String i18n) {
            this.i18n = i18n;
        }

        public EnumBatteryShareMode cycle() {
            return EnumBatteryShareMode.values()[(this.ordinal() + 1) % EnumBatteryShareMode.values().length];
        }

        public boolean isChargingArmor() {
            return this == ARMOR || this == ARMOR_AND_HOTBAR;
        }

        public boolean isChargingHotbar() {
            return this == HOTBAR || this == ARMOR_AND_HOTBAR;
        }

        public boolean isChargingEntireInventory() {
            return this == ENTIRE_INVENTORY;
        }

        public String toString() {
            return I18n.func_74838_a((String)("battery.hammercore:mode." + this.i18n));
        }
    }
}

