/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.core.item.tool.ItemToolCore;
import cofh.lib.util.capabilities.EnergyContainerItemWrapper;
import cofh.lib.util.helpers.DamageHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.init.RAProps;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemToolRF
extends ItemToolCore
implements IMultiModeItem,
IEnergyContainerItem {
    protected int maxEnergy = 320000;
    protected int maxTransfer = 4000;
    protected int energyPerUse = 200;
    protected int energyPerUseCharged = 800;
    protected int damage = 0;

    public ItemToolRF(float baseDamage, float attackSpeed, Item.ToolMaterial toolMaterial) {
        super(baseDamage, attackSpeed, toolMaterial);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> this.getEnergyStored(stack) > 0 && !this.isEmpowered(stack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("empowered"), (stack, world, entity) -> this.isEmpowered(stack) ? 1.0f : 0.0f);
    }

    public ItemToolRF(float attackSpeed, Item.ToolMaterial toolMaterial) {
        this(0.0f, attackSpeed, toolMaterial);
    }

    public ItemToolRF setEnergyParams(int maxEnergy, int maxTransfer, int energyPerUse, int energyPerUseCharged) {
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        this.energyPerUse = energyPerUse;
        this.energyPerUseCharged = energyPerUseCharged;
        return this;
    }

    protected boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) == 1 && this.getEnergyStored(stack) > this.energyPerUseCharged;
    }

    protected int getEnergyPerUse(ItemStack stack) {
        int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)4);
        return (this.isEmpowered(stack) ? this.energyPerUseCharged : this.energyPerUse) * (5 - unbreakingLevel) / 5;
    }

    protected int useEnergy(ItemStack stack, boolean simulate) {
        int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)4);
        return this.extractEnergy(stack, this.isEmpowered(stack) ? this.energyPerUseCharged * (5 - unbreakingLevel) / 5 : this.energyPerUse * (5 - unbreakingLevel) / 5, simulate);
    }

    protected float getEfficiency(ItemStack stack) {
        if (this.isEmpowered(stack) && this.getEnergyStored(stack) >= this.energyPerUseCharged) {
            return this.field_77864_a * 1.5f;
        }
        return this.field_77864_a;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.formatNumber((long)stack.func_77978_p().func_74762_e("Energy")) + " / " + StringHelper.formatNumber((long)this.maxEnergy) + " RF");
        list.add("\u00a76" + this.getEnergyPerUse(stack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        RAProps.addEmpoweredTip(this, stack, list);
        if (this.getEnergyStored(stack) >= this.getEnergyPerUse(stack)) {
            int adjustedDamage = (int)((double)this.damage + player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b());
            list.add("");
            list.add("\u00a79+" + adjustedDamage + " " + StringHelper.localize((String)"info.cofh.damageAttack") + "\u00a7r");
            list.add("\u00a7a+" + (this.isEmpowered(stack) ? 2 : 1) + " " + StringHelper.localize((String)"info.cofh.damageFlux") + "\u00a7r");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        if (this.showInCreative) {
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item), (int)0));
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item), (int)this.maxEnergy));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(0);
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase player) {
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(0);
        }
        EntityPlayer thePlayer = (EntityPlayer)player;
        if (thePlayer.field_71075_bZ.field_75098_d || this.extractEnergy(stack, this.energyPerUse, false) == this.energyPerUse) {
            int fluxDamage = this.isEmpowered(stack) ? 2 : 1;
            float potionDamage = 1.0f;
            if (player.func_70644_a(MobEffects.field_76420_g)) {
                potionDamage += (float)player.func_70660_b(MobEffects.field_76420_g).func_76458_c() * 1.3f;
            }
            entity.func_70097_a(DamageHelper.causePlayerFluxDamage((EntityPlayer)thePlayer), (float)fluxDamage * potionDamage);
        }
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Energy"}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return RAProps.showToolCharge && stack.func_77978_p() != null && !stack.func_77978_p().func_74767_n("CreativeTab");
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.getEnergyStored(stack) < this.energyPerUse) {
            return 1.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.maxEnergy;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isEmpowered(stack) ? EnumRarity.RARE : EnumRarity.UNCOMMON;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
            if (this.extractEnergy(stack, this.energyPerUse, true) == this.energyPerUse) {
                int fluxDamage = this.isEmpowered(stack) ? 2 : 1;
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(fluxDamage + this.damage), 0));
            } else {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 1.0, 0));
            }
        }
        return multimap;
    }

    public int getMode(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Mode");
    }

    public boolean setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Mode", mode);
        return false;
    }

    public boolean incrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (++curMode >= this.getNumModes(stack)) {
            curMode = 0;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public boolean decrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (--curMode <= 0) {
            curMode = this.getNumModes(stack) - 1;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public int getNumModes(ItemStack stack) {
        return 2;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        if (this.isEmpowered(stack)) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.4f, 1.0f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.2f, 0.6f);
        }
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.maxEnergy - stored, this.maxTransfer));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        if (container.func_77978_p().func_74764_b("Unbreakable")) {
            container.func_77978_p().func_82580_o("Unbreakable");
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
            if (stored == 0) {
                this.setMode(container, 0);
            }
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }
}

