/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.lib.util.RayTracer;
import cofh.redstonearsenal.item.tool.ItemToolRF;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemHammerRF
extends ItemToolRF {
    public ItemHammerRF(Item.ToolMaterial toolMaterial) {
        super(-3.6f, toolMaterial);
        this.addToolClass("pickaxe");
        this.addToolClass("hammer");
        this.damage = 11;
        this.energyPerUseCharged = 1600;
        this.field_150914_c.addAll((Collection)ItemPickaxe.field_150915_c);
        this.effectiveMaterials.add((Object)Material.field_151573_f);
        this.effectiveMaterials.add((Object)Material.field_151574_g);
        this.effectiveMaterials.add((Object)Material.field_151576_e);
        this.effectiveMaterials.add((Object)Material.field_151588_w);
        this.effectiveMaterials.add((Object)Material.field_151598_x);
        this.effectiveMaterials.add((Object)Material.field_151592_s);
        this.effectiveMaterials.add((Object)Material.field_151591_t);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (!this.canHarvestBlock(state, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return false;
        }
        boolean used = false;
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        float refStrength = state.func_185903_a(player, world, pos);
        if (refStrength != 0.0f) {
            RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player);
            if (traceResult == null) {
                return false;
            }
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int radius = this.isEmpowered(stack) ? 2 : 1;
            switch (traceResult.field_178784_b) {
                case DOWN: 
                case UP: {
                    for (x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
                        for (z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                            BlockPos adjPos = new BlockPos(x, y, z);
                            IBlockState adjState = world.func_180495_p(adjPos);
                            float strength = adjState.func_185903_a(player, world, adjPos);
                            if (!(strength > 0.0f) || !(refStrength / strength <= 10.0f)) continue;
                            used |= this.harvestBlock(world, adjPos, player);
                        }
                    }
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    for (x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
                        for (y = pos.func_177956_o() - radius; y <= pos.func_177956_o() + radius; ++y) {
                            BlockPos adjPos = new BlockPos(x, y, z);
                            IBlockState adjState = world.func_180495_p(adjPos);
                            float strength = adjState.func_185903_a(player, world, adjPos);
                            if (!(strength > 0.0f) || !(refStrength / strength <= 10.0f)) continue;
                            used |= this.harvestBlock(world, adjPos, player);
                        }
                    }
                    break;
                }
                case WEST: 
                case EAST: {
                    for (y = pos.func_177956_o() - radius; y <= pos.func_177956_o() + radius; ++y) {
                        for (z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                            BlockPos adjPos = new BlockPos(x, y, z);
                            IBlockState adjState = world.func_180495_p(adjPos);
                            float strength = adjState.func_185903_a(player, world, adjPos);
                            if (!(strength > 0.0f) || !(refStrength / strength <= 10.0f)) continue;
                            used |= this.harvestBlock(world, adjPos, player);
                        }
                    }
                    break;
                }
            }
            if (used && !player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
        }
        return true;
    }
}

