/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;

public abstract class TagPlayerGeneral
extends Tag {
    protected final MBlockPos pos = new MBlockPos();

    @Override
    public String getCategory() {
        return "playergeneral";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new Light().setName("light"));
        TagRegistry.INSTANCE.register(new LightEye().setName("lighteye"));
        TagRegistry.INSTANCE.register(new LightNoSun().setName("lightnosun"));
        TagRegistry.INSTANCE.register(new LightNoSunEye().setName("lightnosuneye"));
        TagRegistry.INSTANCE.register(new LightSun().setName("lightsun"));
        TagRegistry.INSTANCE.register(new LightSunEye().setName("lightsuneye"));
        TagRegistry.INSTANCE.register(new Score().setName("score"));
        TagRegistry.INSTANCE.register(new GameMode().setName("gamemode"));
        TagRegistry.INSTANCE.register(new GameModeId().setName("gamemodeid"));
        TagRegistry.INSTANCE.register(new Health().setName("health").setAliases("healthpoints"));
        TagRegistry.INSTANCE.register(new MaxHealth().setName("maxhealth").setAliases("maxhealthpoints"));
        TagRegistry.INSTANCE.register(new Armor().setName("armor").setAliases("armorpoints"));
        TagRegistry.INSTANCE.register(new FoodLevel().setName("foodlevel").setAliases("foodpoints"));
        TagRegistry.INSTANCE.register(new MaxFoodLevel().setName("maxfoodlevel").setAliases("maxfoodpoints"));
        TagRegistry.INSTANCE.register(new Saturation().setName("saturation").setAliases("foodsaturation"));
        TagRegistry.INSTANCE.register(new Exhaustion().setName("exhaustion").setAliases("foodexhaustion"));
        TagRegistry.INSTANCE.register(new AirTicks().setName("airticks"));
        TagRegistry.INSTANCE.register(new MaxAirTicks().setName("maxairticks"));
        TagRegistry.INSTANCE.register(new PlayerLevel().setName("playerlevel"));
        TagRegistry.INSTANCE.register(new CurrentExperience().setName("xpthislevel"));
        TagRegistry.INSTANCE.register(new ExperienceUntilNext().setName("xpuntilnext"));
        TagRegistry.INSTANCE.register(new ExperienceCap().setName("xpcap"));
        TagRegistry.INSTANCE.register(new Username().setName("username"));
        TagRegistry.INSTANCE.register(new InWater().setName("inwater").setAliases("underwater"));
        TagRegistry.INSTANCE.register(new Wet().setName("wet"));
        TagRegistry.INSTANCE.register(new Alive().setName("alive"));
        TagRegistry.INSTANCE.register(new Burning().setName("burning"));
        TagRegistry.INSTANCE.register(new Riding().setName("riding"));
        TagRegistry.INSTANCE.register(new Sneaking().setName("sneaking"));
        TagRegistry.INSTANCE.register(new Sprinting().setName("sprinting"));
        TagRegistry.INSTANCE.register(new Invisible().setName("invisible"));
        TagRegistry.INSTANCE.register(new Eating().setName("eating"));
    }

    public static class Eating
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(false);
        }
    }

    public static class Invisible
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_82150_aj());
        }
    }

    public static class Sprinting
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_70051_ag());
        }
    }

    public static class Sneaking
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_70093_af());
        }
    }

    public static class Riding
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_184218_aH());
        }
    }

    public static class Burning
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_70027_ad());
        }
    }

    public static class Alive
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_70089_S());
        }
    }

    public static class Wet
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_70026_G());
        }
    }

    public static class InWater
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_70090_H());
        }
    }

    public static class Username
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return player.func_146103_bH().getName();
        }
    }

    public static class ExperienceCap
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_71050_bK());
        }
    }

    public static class ExperienceUntilNext
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf((int)Math.floor((1.0 - (double)ExperienceUntilNext.player.field_71106_cc) * (double)player.func_71050_bK()));
        }
    }

    public static class CurrentExperience
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf((int)Math.ceil(CurrentExperience.player.field_71106_cc * (float)player.func_71050_bK()));
        }
    }

    public static class PlayerLevel
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(PlayerLevel.player.field_71068_ca);
        }
    }

    public static class MaxAirTicks
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(300);
        }
    }

    public static class AirTicks
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_70086_ai());
        }
    }

    public static class Exhaustion
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(Exhaustion.player.func_71024_bL().field_75126_c));
        }
    }

    public static class Saturation
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(player.func_71024_bL().func_75115_e()));
        }
    }

    public static class MaxFoodLevel
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(20);
        }
    }

    public static class FoodLevel
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_71024_bL().func_75116_a());
        }
    }

    public static class Armor
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(player.func_70658_aO());
        }
    }

    public static class MaxHealth
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(player.func_110138_aP()));
        }
    }

    public static class Health
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(player.func_110143_aJ()));
        }
    }

    public static class GameModeId
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return String.valueOf(GameModeId.minecraft.field_71442_b.func_178889_l().func_77148_a());
        }
    }

    public static class GameMode
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            return I18n.func_135052_a((String)("selectWorld.gameMode." + GameMode.minecraft.field_71442_b.func_178889_l().func_77149_b()), (Object[])new Object[0]);
        }
    }

    public static class Score
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            try {
                return String.valueOf(player.func_71037_bA());
            }
            catch (Exception var12) {
                return "0";
            }
        }
    }

    public static class LightSunEye
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            try {
                this.pos.set((double)playerPosition.func_177958_n(), LightSunEye.player.field_70163_u + (double)player.func_70047_e(), (double)playerPosition.func_177952_p());
                return String.valueOf(MathHelper.func_76125_a((int)(world.func_175642_b(EnumSkyBlock.SKY, (BlockPos)this.pos) - world.func_72967_a(1.0f)), (int)0, (int)15));
            }
            catch (Exception e) {
                return "0";
            }
        }
    }

    public static class LightSun
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            try {
                return String.valueOf(MathHelper.func_76125_a((int)(world.func_175642_b(EnumSkyBlock.SKY, (BlockPos)playerPosition) - world.func_72967_a(1.0f)), (int)0, (int)15));
            }
            catch (Exception e) {
                return "0";
            }
        }
    }

    public static class LightNoSunEye
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            try {
                this.pos.set((double)playerPosition.func_177958_n(), LightNoSunEye.player.field_70163_u + (double)player.func_70047_e(), (double)playerPosition.func_177952_p());
                return String.valueOf(world.func_175642_b(EnumSkyBlock.BLOCK, (BlockPos)this.pos));
            }
            catch (Exception e) {
                return "0";
            }
        }
    }

    public static class LightNoSun
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            try {
                return String.valueOf(world.func_175642_b(EnumSkyBlock.BLOCK, (BlockPos)playerPosition));
            }
            catch (Exception e) {
                return "0";
            }
        }
    }

    public static class LightEye
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            try {
                this.pos.set((double)playerPosition.func_177958_n(), LightEye.player.field_70163_u + (double)player.func_70047_e(), (double)playerPosition.func_177952_p());
                return String.valueOf(world.func_175726_f((BlockPos)this.pos).func_177443_a((BlockPos)this.pos, world.func_72967_a(1.0f)));
            }
            catch (Exception e) {
                return "0";
            }
        }
    }

    public static class Light
    extends TagPlayerGeneral {
        @Override
        public String getValue() {
            try {
                return String.valueOf(world.func_175726_f((BlockPos)playerPosition).func_177443_a((BlockPos)playerPosition, world.func_72967_a(1.0f)));
            }
            catch (Exception e) {
                return "0";
            }
        }
    }
}

