/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.te.cable;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.mrdimka.common.utils.CommonTileEntity_SFR;
import com.mrdimka.solarfluxreborn.network.energy.cable.CableNetwork;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileAbstractCable
extends CommonTileEntity_SFR
implements IEnergyReceiver,
IEnergyProvider {
    public CableNetwork network;
    public double internal;
    boolean wasUnloaded = false;

    public void func_73660_a() {
        if (this.network == null) {
            EnumFacing[] nets = new HashSet();
            for (EnumFacing f : EnumFacing.field_82609_l) {
                TileEntity t = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
                if (!(t instanceof TileAbstractCable)) continue;
                TileAbstractCable w = (TileAbstractCable)t;
                if (w.network == null) continue;
                nets.add(w.network);
            }
            if (nets.size() > 0) {
                CableNetwork netC = null;
                int size = 0;
                for (CableNetwork n : nets.toArray(new CableNetwork[0])) {
                    if (n.wires.size() > size) {
                        size = n.wires.size();
                        netC = n;
                        continue;
                    }
                    if (n.wires.size() != size) continue;
                    netC = n;
                }
                this.network = netC;
            }
            if (this.network == null) {
                this.network = new CableNetwork();
            }
            this.network.connect(this);
        } else {
            this.network.connect(this);
            this.network.markTicked(this);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                TileEntity t = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
                if (!(t instanceof TileAbstractCable)) continue;
                TileAbstractCable w = (TileAbstractCable)t;
                if (w.network == null || w.network == this.network) continue;
                if (w.network.wires.size() > this.network.wires.size()) {
                    w.network.merge(this.network);
                    continue;
                }
                this.network.merge(w.network);
            }
        }
        if (this.network != null && this.network.energy > 0.0) {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                IEnergyReceiver r;
                BlockPos p = this.func_174877_v().func_177972_a(f);
                TileEntity t = this.field_145850_b.func_175625_s(p);
                if (t instanceof TileAbstractCable || !(t instanceof IEnergyReceiver) || !(r = (IEnergyReceiver)t).canConnectEnergy(f.func_176734_d())) continue;
                int sent = r.receiveEnergy(f.func_176734_d(), Math.min((int)this.getCapacityAddedToNet(), (int)this.network.energy), false);
                this.network.energy -= (double)sent;
            }
        }
    }

    public double getCapacityAddedToNet() {
        return 80.0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing facing) {
        return true;
    }

    @Override
    public int getEnergyStored(EnumFacing facing) {
        if (this.network == null) {
            return 0;
        }
        return (int)this.network.energy;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing facing) {
        if (this.network == null) {
            return 0;
        }
        return (int)this.network.capacity;
    }

    @Override
    public int receiveEnergy(EnumFacing facing, int maxReceive, boolean simulate) {
        if (this.network == null) {
            return 0;
        }
        int energyReceived = (int)Math.min(this.network.capacity - this.network.energy, (double)maxReceive);
        if (!simulate) {
            this.network.energy += (double)energyReceived;
        }
        return energyReceived;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.internal = nbt.func_74769_h("EnergyStored");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("EnergyStored", this.internal);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.wasUnloaded = true;
        if (this.network != null) {
            this.network.splitEnergyTo1Wire(this);
            this.network.disconnect(this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.wasUnloaded && this.network != null) {
            CableNetwork network = this.network;
            network.disconnect(this);
            network.energy += this.internal;
        }
    }

    public String getResourceConnection() {
        return "solarfluxreborn:blocks/wire_1";
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int sent = Math.min((int)this.getCapacityAddedToNet(), (int)this.network.energy);
        if (!simulate) {
            this.network.energy -= (double)sent;
        }
        return sent;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.network != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.network != null) {
            return (T)this.network;
        }
        return (T)super.getCapability(capability, facing);
    }
}

