/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.init;

import com.google.common.collect.Lists;
import com.mrdimka.solarfluxreborn.blocks.BlockCable320;
import com.mrdimka.solarfluxreborn.blocks.BlockCable3200;
import com.mrdimka.solarfluxreborn.blocks.BlockCable320000;
import com.mrdimka.solarfluxreborn.blocks.DraconicSolarPanelBlock;
import com.mrdimka.solarfluxreborn.blocks.SolarPanelBlock;
import com.mrdimka.solarfluxreborn.config.DraconicEvolutionConfigs;
import com.mrdimka.solarfluxreborn.config.ModConfiguration;
import com.mrdimka.solarfluxreborn.items.CableItemBlock;
import com.mrdimka.solarfluxreborn.items.SolarPanelItemBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ModBlocks {
    private static final List<Block> mSolarPanels = Lists.newArrayList();
    public static final Block cable1 = new BlockCable320();
    public static final Block cable2 = new BlockCable3200();
    public static final Block cable3 = new BlockCable320000();
    public static DraconicSolarPanelBlock draconicSolar;
    public static DraconicSolarPanelBlock chaoticSolar;

    private ModBlocks() {
    }

    public static void initialize() {
        mSolarPanels.clear();
        for (int tierIndex = 0; tierIndex < ModConfiguration.getTierConfigurations().size(); ++tierIndex) {
            SolarPanelBlock block = new SolarPanelBlock("solar" + tierIndex, tierIndex);
            ModBlocks.register((Block)block, "solar" + tierIndex, new SolarPanelItemBlock((Block)block));
            mSolarPanels.add((Block)block);
        }
        if (DraconicEvolutionConfigs.canIntegrate) {
            if (DraconicEvolutionConfigs.draconicSolar) {
                DraconicSolarPanelBlock block;
                draconicSolar = block = new DraconicSolarPanelBlock("solardraconic", 512000000, 1024000, 131072);
                ModBlocks.register((Block)draconicSolar, "solardraconic", new SolarPanelItemBlock((Block)block));
                mSolarPanels.add((Block)block);
            }
            if (DraconicEvolutionConfigs.chaoticSolar) {
                DraconicSolarPanelBlock block;
                chaoticSolar = block = new DraconicSolarPanelBlock("solarchaotic", 2048000000, 4096000, 524288);
                ModBlocks.register((Block)chaoticSolar, "solarchaotic", new SolarPanelItemBlock((Block)block));
                mSolarPanels.add((Block)block);
            }
        }
        ModBlocks.register(cable1, "wire_1", new CableItemBlock(cable1));
        ModBlocks.register(cable2, "wire_2", new CableItemBlock(cable2));
        ModBlocks.register(cable3, "wire_3", new CableItemBlock(cable3));
    }

    public static List<Block> getSolarPanels() {
        return mSolarPanels;
    }

    public static Block register(Block block, String name, ItemBlock ib) {
        ib.setRegistryName("solarfluxreborn", name);
        block.setRegistryName("solarfluxreborn", name);
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)ib);
        return block;
    }
}

