/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.blocks.modules;

import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.Lists;
import com.mrdimka.hammercore.ext.TeslaAPI;
import com.mrdimka.solarfluxreborn.blocks.StatefulEnergyStorage;
import com.mrdimka.solarfluxreborn.blocks.modules.AbstractSolarPanelModule;
import com.mrdimka.solarfluxreborn.config.ModConfiguration;
import com.mrdimka.solarfluxreborn.init.ModItems;
import com.mrdimka.solarfluxreborn.te.DraconicSolarPanelTileEntity;
import com.mrdimka.solarfluxreborn.te.SolarPanelTileEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockFurnace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SimpleEnergyDispenserModule
extends AbstractSolarPanelModule {
    private final List<BlockPos> mTargets = Lists.newArrayList();
    private final Map<BlockPos, EnumFacing> mFacings = new HashMap<BlockPos, EnumFacing>();
    private int mTargetStartingIndex;
    private int mFurnaceEnergyBuffer;

    public SimpleEnergyDispenserModule(SolarPanelTileEntity pSolarPanelTileEntity) {
        super(pSolarPanelTileEntity);
    }

    @Override
    public void tick() {
        this.sendEnergyToTargets();
        if (this.atRate(this.getTargetRefreshRate())) {
            this.searchTargets();
        }
    }

    protected int getTargetRefreshRate() {
        return 20;
    }

    protected void searchTargets() {
        this.mTargets.clear();
        BlockPos position = ((SolarPanelTileEntity)this.getTileEntity()).func_174877_v();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            BlockPos neighbor = position.func_177972_a(direction);
            if (!this.isValidTarget(neighbor)) continue;
            this.mTargets.add(neighbor);
            this.mFacings.put(neighbor, direction);
        }
    }

    protected List<BlockPos> getTargets() {
        return this.mTargets;
    }

    protected void sendEnergyToTargets() {
        if (this.mTargets.size() > 0 && ((SolarPanelTileEntity)this.getTileEntity()).getEnergyStored() > 0) {
            for (int i = 0; i < this.mTargets.size(); ++i) {
                BlockPos pos = this.mTargets.get((this.mTargetStartingIndex + i) % this.mTargets.size());
                this.sendEnergyTo(pos, this.mFacings.get(pos));
            }
            this.mTargetStartingIndex = (this.mTargetStartingIndex + 1) % this.mTargets.size();
        }
    }

    protected boolean isValidTarget(BlockPos pos) {
        TileEntity tile = ((SolarPanelTileEntity)this.getTileEntity()).func_145831_w().func_175625_s(pos);
        return tile instanceof IEnergyReceiver || ((SolarPanelTileEntity)this.getTileEntity()).getUpgradeCount(ModItems.mUpgradeFurnace) > 0 && tile instanceof TileEntityFurnace;
    }

    protected void sendEnergyTo(BlockPos pos, EnumFacing to) {
        TileEntity tile = ((SolarPanelTileEntity)this.getTileEntity()).func_145831_w().func_175625_s(pos);
        if (tile instanceof IEnergyReceiver) {
            this.sendEnergyToReceiver((IEnergyReceiver)tile, to.func_176734_d());
        } else if (((SolarPanelTileEntity)this.getTileEntity()).getUpgradeCount(ModItems.mUpgradeFurnace) > 0 && tile instanceof TileEntityFurnace) {
            this.sendEnergyToFurnace((TileEntityFurnace)tile);
        } else if (TeslaAPI.isTeslaConsumer((TileEntity)tile)) {
            this.sendEnergyToTeslaReceiver(tile, to.func_176734_d());
        }
    }

    protected void sendEnergyToReceiver(IEnergyReceiver pEnergyReceiver, EnumFacing pFrom) {
        ((SolarPanelTileEntity)this.getTileEntity()).getEnergyStorage().sendMaxTo(pEnergyReceiver, pFrom);
    }

    protected void sendEnergyToTeslaReceiver(TileEntity t, EnumFacing pFrom) {
        if (TeslaAPI.isTeslaConsumer((TileEntity)t)) {
            StatefulEnergyStorage storage = ((SolarPanelTileEntity)this.getTileEntity()).getEnergyStorage();
            storage.extractEnergy((int)TeslaAPI.givePowerToConsumer((TileEntity)t, (long)storage.getMaxExtract(), (boolean)false), false);
        }
    }

    protected void sendEnergyToFurnace(TileEntityFurnace pFurnace) {
        int burnTicksAvailable;
        SolarPanelTileEntity solar;
        int FURNACE_COOKING_TICKS = 200;
        int FURNACE_COOKING_ENERGY = 200 * ModConfiguration.getFurnaceUpgradeHeatingConsumption();
        if (this.mFurnaceEnergyBuffer < FURNACE_COOKING_ENERGY) {
            this.mFurnaceEnergyBuffer += ((SolarPanelTileEntity)this.getTileEntity()).getEnergyStorage().extractEnergy(FURNACE_COOKING_ENERGY - this.mFurnaceEnergyBuffer, false);
        }
        if (((solar = (SolarPanelTileEntity)this.getTileEntity()).getTier() > 0 || solar instanceof DraconicSolarPanelTileEntity) && pFurnace.func_145950_i()) {
            int tier = solar.getTier();
            if (solar instanceof DraconicSolarPanelTileEntity) {
                tier = 100;
            }
            if (pFurnace.func_174887_a_(2) < 200) {
                pFurnace.func_174885_b(2, pFurnace.func_174887_a_(2) + tier);
            }
            if (pFurnace.func_174887_a_(2) >= 200) {
                pFurnace.func_145949_j();
                pFurnace.func_174885_b(2, 0);
            }
        }
        if (pFurnace.func_70301_a(0) != null && pFurnace.func_174887_a_(0) < 200 && (burnTicksAvailable = this.mFurnaceEnergyBuffer / ModConfiguration.getFurnaceUpgradeHeatingConsumption()) >= 200) {
            if (pFurnace.func_174887_a_(0) == 0) {
                pFurnace.func_174885_b(0, pFurnace.func_174887_a_(0) + 1);
                BlockFurnace.func_176446_a((pFurnace.func_174887_a_(0) > 0 ? 1 : 0) != 0, (World)pFurnace.func_145831_w(), (BlockPos)pFurnace.func_174877_v());
            }
            pFurnace.func_174885_b(0, pFurnace.func_174887_a_(0) + 200);
            this.mFurnaceEnergyBuffer -= 200 * ModConfiguration.getFurnaceUpgradeHeatingConsumption();
        }
    }
}

