/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn;

import com.mrdimka.solarfluxreborn.config.DraconicEvolutionConfigs;
import com.mrdimka.solarfluxreborn.config.ModConfiguration;
import com.mrdimka.solarfluxreborn.err.NoSolarsRegisteredException;
import com.mrdimka.solarfluxreborn.gui.GuiHandler;
import com.mrdimka.solarfluxreborn.init.ModBlocks;
import com.mrdimka.solarfluxreborn.init.ModItems;
import com.mrdimka.solarfluxreborn.init.RecipeIO;
import com.mrdimka.solarfluxreborn.proxy.CommonProxy;
import com.mrdimka.solarfluxreborn.te.DraconicSolarPanelTileEntity;
import com.mrdimka.solarfluxreborn.te.SolarPanelTileEntity;
import com.mrdimka.solarfluxreborn.te.cable.TileCustomCable;
import com.mrdimka.solarfluxreborn.utility.SFRLog;
import java.io.File;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="solarfluxreborn", name="Solar Flux Reborn", version="2.17r", guiFactory="com.mrdimka.solarfluxreborn.config.ConfigurationGuiFactory", dependencies="required-after:hammercore@[1.6.9,)", acceptedMinecraftVersions="[1.10.2]")
public class SolarFluxRebornMod {
    @Mod.Instance(value="solarfluxreborn")
    public static SolarFluxRebornMod instance;
    @SidedProxy(clientSide="com.mrdimka.solarfluxreborn.proxy.ClientProxy", serverSide="com.mrdimka.solarfluxreborn.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static File cfgFolder;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent pEvent) {
        String cfg = pEvent.getSuggestedConfigurationFile().getAbsolutePath();
        cfg = cfg.substring(0, cfg.length() - 4);
        cfgFolder = new File(cfg);
        cfgFolder.mkdirs();
        File main_cfg = new File(cfgFolder, "main.cfg");
        File draconicevolution = new File(cfgFolder, "DraconicEvolution.cfg");
        File version_file = new File(cfgFolder, "version.dat");
        ModConfiguration.initialize(main_cfg, version_file);
        DraconicEvolutionConfigs.initialize(draconicevolution);
        GameRegistry.registerTileEntity(SolarPanelTileEntity.class, (String)"solarfluxreborn:solar");
        GameRegistry.registerTileEntity(DraconicSolarPanelTileEntity.class, (String)"solarfluxreborn:draconicsolar");
        GameRegistry.registerTileEntity(TileCustomCable.class, (String)"solarfluxreborn:cable_custom");
        ModBlocks.initialize();
        if (ModBlocks.getSolarPanels().isEmpty()) {
            try {
                main_cfg.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new NoSolarsRegisteredException("No solar panels was registered in config file.\nSolarFluxReborn configs were removed. If not, please remove file \"" + main_cfg.getAbsolutePath() + "\" manually.\nTry restarting game.", false);
        }
        ModItems.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        RecipeIO.reload();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent pEvent) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.mrdimka.solarfluxreborn.intr.waila.WailaIntegrar.registerWAIA");
        proxy.init();
    }

    @Mod.EventHandler
    public void printMessage(FMLServerStartedEvent e) {
        if (ModConfiguration.willNotify) {
            SFRLog.bigWarning(TextFormatting.RED + "WARNING: Your configs have been replaced.", new Object[0]);
            ModConfiguration.updateNotification(false);
        }
    }
}

