/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.network;

import com.nekokittygames.mffs.common.ModularForceFieldSystem;
import com.nekokittygames.mffs.common.tileentity.TileEntityMachines;
import com.nekokittygames.mffs.network.PacketTile;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketTileHandler
extends PacketTile<TileEntityMachines>
implements IMessageHandler<PacketTileHandler, IMessage> {
    int eventType;
    String eventData;

    public PacketTileHandler() {
    }

    public PacketTileHandler(TileEntityMachines tile, int eventType, String eventData) {
        super(tile);
        this.eventType = eventType;
        this.eventData = eventData;
    }

    @Override
    public void fromBytes(ByteBuf byteBuf) {
        super.fromBytes(byteBuf);
        this.eventType = byteBuf.readInt();
        this.eventData = ByteBufUtils.readUTF8String((ByteBuf)byteBuf);
    }

    @Override
    public void toBytes(ByteBuf byteBuf) {
        super.toBytes(byteBuf);
        byteBuf.writeInt(this.eventType);
        ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)this.eventData);
    }

    public IMessage onMessage(final PacketTileHandler message, final MessageContext ctx) {
        super.onMessage(message, ctx);
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

            @Override
            public void run() {
                PacketTileHandler.this.handle(message, ctx);
            }
        });
        return null;
    }

    private void handle(PacketTileHandler message, MessageContext ctx) {
        TileEntity tile;
        World world = ctx.side == Side.CLIENT ? ModularForceFieldSystem.proxy.getClientWorld() : ctx.getServerHandler().field_147369_b.func_130014_f_();
        if (world == null) {
            // empty if block
        }
        if ((tile = world.func_175625_s(new BlockPos(message.x, message.y, message.z))) != null) {
            message.tile = (TileEntityMachines)tile;
        }
        ((TileEntityMachines)tile).onNetworkHandlerEvent(message.eventType, message.eventData);
    }
}

